/*
 * Decompiled with CFR 0.152.
 */
package com.drathonix.loadmychunks.common.system.loaders.extension;

import com.drathonix.loadmychunks.common.system.ChunkDataManager;
import com.drathonix.loadmychunks.common.system.loaders.IChunkLoader;
import com.drathonix.loadmychunks.common.system.loaders.extension.IExtensionChunkLoader;
import com.drathonix.loadmychunks.common.util.ReferenceHelper;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import net.minecraft.class_1923;
import net.minecraft.class_3218;

public class ExtensionChunkLoaders
extends Long2ObjectOpenHashMap<IExtensionChunkLoader<?>> {
    private final class_3218 level;
    private final Object host;

    public ExtensionChunkLoaders(class_3218 level, Object host) {
        ReferenceHelper.assertIsType(IChunkLoader.class, host);
        this.level = level;
        this.host = host;
    }

    public synchronized <T extends IExtensionChunkLoader<?>> void recompute(Class<T> extensionType, int range, Factory<T> factory) {
        for (IExtensionChunkLoader extensionChunkLoader : this.values()) {
            extensionChunkLoader.removeHostAndUnload(this.level, this.host);
        }
        this.clear();
        if (range < 1) {
            return;
        }
        class_1923 hostPos = ReferenceHelper.get(IChunkLoader.class, this.host).getChunkPos();
        for (int x = -range; x <= range; ++x) {
            for (int z = -range; z <= range; ++z) {
                if (z == 0 && x == 0) continue;
                class_1923 pos = new class_1923(x, z);
                long gridPos = pos.method_8324();
                class_1923 cp = new class_1923(hostPos.field_9181 + x, hostPos.field_9180 + z);
                IExtensionChunkLoader loader = ChunkDataManager.computeChunkLoaderIfAbsent(this.level, cp, extensionType, present -> true, () -> factory.create(cp));
                loader.addHost(this.host);
                this.put(gridPos, loader);
            }
        }
    }

    public synchronized IExtensionChunkLoader<?> remove(long k) {
        IExtensionChunkLoader ecl = (IExtensionChunkLoader)super.remove(k);
        if (ecl != null) {
            ecl.removeHostAndUnload(this.level, this.host);
        }
        return ecl;
    }

    public void requestUpdates() {
        for (IExtensionChunkLoader ecl : this.values()) {
            ChunkDataManager.requestUpdate(this.level, ecl.getChunkPos());
        }
    }

    @FunctionalInterface
    public static interface Factory<T extends IExtensionChunkLoader<?>> {
        public T create(class_1923 var1);
    }
}

