/*
 * Decompiled with CFR 0.152.
 */
package com.drathonix.loadmychunks.common.system.loaders.extension;

import com.drathonix.loadmychunks.common.config.LMCConfig;
import com.drathonix.loadmychunks.common.registry.LoaderTypeKeys;
import com.drathonix.loadmychunks.common.registry.custom.LoadStateRegistry;
import com.drathonix.loadmychunks.common.system.ChunkDataManager;
import com.drathonix.loadmychunks.common.system.control.ILoadState;
import com.drathonix.loadmychunks.common.system.loaders.DoNotAddException;
import com.drathonix.loadmychunks.common.system.loaders.IOwnable;
import com.drathonix.loadmychunks.common.system.loaders.PlacedChunkLoader;
import com.drathonix.loadmychunks.common.system.loaders.extension.ExtensionChunkLoader;
import java.util.UUID;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2501;
import net.minecraft.class_2503;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlacedExtensionChunkLoader
extends ExtensionChunkLoader<PlacedChunkLoader>
implements IOwnable {
    protected long activityEnd = -1L;

    public PlacedExtensionChunkLoader() {
    }

    public PlacedExtensionChunkLoader(class_1923 loadedChunk, PlacedChunkLoader host) {
        super(host, loadedChunk);
    }

    @Override
    @NotNull
    public class_2487 save(@NotNull class_2487 tag) {
        tag = super.save(tag);
        class_2501 hostsTag = new class_2501(new long[0]);
        for (int i = 0; i < this.hosts.length; ++i) {
            hostsTag.add((Object)class_2503.method_23251((long)((PlacedChunkLoader)this.getHost(i)).getPosition().method_10063()));
        }
        tag.method_10566("hosts", (class_2520)hostsTag);
        tag.method_10544("duration", this.activityEnd);
        return tag;
    }

    @Override
    public void load(@NotNull class_2487 tag, class_3218 level) throws DoNotAddException {
        long[] hostPoses = tag.method_10565("host");
        this.hosts = new PlacedChunkLoader[hostPoses.length];
        if (this.hosts.length == 0) {
            throw new DoNotAddException();
        }
        for (int i = 0; i < this.hosts.length; ++i) {
            class_2338 p = class_2338.method_10092((long)hostPoses[i]);
            this.hosts[i] = ChunkDataManager.computeChunkLoaderIfAbsent(level, p, PlacedChunkLoader.class, loader -> loader.getPosition().equals((Object)p), () -> new PlacedChunkLoader(p));
        }
        if (tag.method_10545("duration")) {
            this.activityEnd = tag.method_10537("duration");
        }
        super.load(tag, level);
    }

    @Override
    @Nullable
    public UUID getOwner() {
        PlacedChunkLoader pcl = (PlacedChunkLoader)this.getPrimaryHostLoader();
        if (pcl != null) {
            return pcl.getOwner();
        }
        return null;
    }

    @Override
    public void setOwner(@NotNull UUID owner) {
    }

    @Override
    public class_2960 getTypeId() {
        return LoaderTypeKeys.PLACED_EXTENSION_LOADER;
    }

    @Override
    public ILoadState getActiveState() {
        if (this.hasExceededChunkLimit() || LMCConfig.cost.enabled && this.activityEnd == -1L) {
            return LoadStateRegistry.DISABLED;
        }
        return super.getActiveState();
    }

    @Override
    @NotNull
    public class_2338 getItemSource() {
        return ((PlacedChunkLoader)this.getPrimaryHostLoader()).getItemSource();
    }

    @Override
    public boolean shouldConsumeItems() {
        return this.isHosted() && super.shouldConsumeItems();
    }
}

