package com.drathonix.loadmychunks.common.registry;

//? if >1.18.1
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
//? if <=1.16.5
/*import me.shedaniel.architectury.registry.RegistrySupplier;*/

import java.util.function.Supplier;

//? if >1.16.5 {
import com.mojang.datafixers.util.Either;
import dev.architectury.registry.registries.RegistrySupplier;
import dev.architectury.registry.registries.Registrar;
//? if <1.19.3
/*import dev.architectury.registry.registries.Registries;*/
//? if >1.19.3
import dev.architectury.registry.registries.RegistrarManager;
//?}
//? if >1.20.3 {
import net.minecraft.core.HolderOwner;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;

import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
//?}

/**
 * Used to instantiate architectury registry suppliers in older versions. Merely used for versioning simplification
 * @since 1.0.0
 * @author Jack Andersen
 */
@SuppressWarnings("NonExtendableApiUsage")
public class FakeRegistrySupplier<T> implements RegistrySupplier<T> {
    private final Supplier<T> supplier;
    private T t;

    public FakeRegistrySupplier(T t) {
        this.supplier = () -> t;
    }
    public FakeRegistrySupplier(Supplier<T> supplier) {
        this.supplier=supplier;
    }

    @Override
    public ResourceLocation getRegistryId() {
        return null;
    }

    @Override
    public ResourceLocation getId() {
        return null;
    }

    @Override
    public boolean isPresent() {
        return false;
    }

    @Override
    public T get() {
        if(t==null) {
            t=supplier.get();
        }
        return t;
    }

    //? if >1.19.3 {
    @Override
    public RegistrarManager getRegistrarManager() {
        return null;
    }
    //?}

    //? if <1.19.3 && >1.16.5 {
    /*@Override
    public Registries getRegistries() {
        return null;
    }
    *///?}

    //? if >1.16.5 {
    @Override
    public Registrar<T> getRegistrar() {
        return null;
    }
    //?}

    //? if >1.20.3 {
    @Override
    public T m_203334_() {
        return null;
    }

    @Override
    public boolean m_203633_() {
        return false;
    }

    @Override
    public boolean m_203373_(ResourceLocation resourceLocation) {
        return false;
    }

    @Override
    public boolean m_203565_(ResourceKey<T> resourceKey) {
        return false;
    }

    @Override
    public boolean m_203425_(Predicate<ResourceKey<T>> predicate) {
        return false;
    }

    @Override
    public boolean m_203656_(TagKey<T> tagKey) {
        return false;
    }

    //? if >1.20.5 {
    /*@Override
    public boolean is(Holder<T> holder) {
        return false;
    }
    *///?}

    @Override
    public Stream<TagKey<T>> m_203616_() {
        return Stream.empty();
    }

    @Override
    public Either<ResourceKey<T>, T> m_203439_() {
        return null;
    }

    @Override
    public Optional<ResourceKey<T>> m_203543_() {
        return Optional.empty();
    }

    @Override
    public Kind m_203376_() {
        return null;
    }

    @Override
    public boolean m_203401_(HolderOwner<T> holderOwner) {
        return false;
    }
    //?}

    //? if >1.20.6 && neoforge {
    /*public ResourceKey<T> getKey() {
        return ResourceKey.create(getRegistryKey(), getId());
    }
    *///?}
}
