package com.drathonix.loadmychunks.common.block.blockentity;

import com.drathonix.loadmychunks.common.bridge.IDestroyable;
import com.drathonix.loadmychunks.common.registry.LMCContent;
import com.drathonix.loadmychunks.common.system.ChunkDataManager;
import com.drathonix.loadmychunks.common.system.loaders.IHasChunkloader;
import com.drathonix.loadmychunks.common.system.loaders.PlacedChunkLoader;
import com.drathonix.loadmychunks.common.util.MultiversioningHelper;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

import java.util.UUID;

public class BlockEntityChunkLoader extends BEBase implements IDestroyable, IHasChunkloader {
    private PlacedChunkLoader chunkLoader;
    private UUID owner = Util.f_137441_;

    //? if <=1.16.5 {
    /*public BlockEntityChunkLoader() {
        super(LMCContent.chunkLoaderBlockEntity.get());
    }
    *///?} else {
    public BlockEntityChunkLoader(BlockPos blockPos, BlockState blockState) {
        super(LMCContent.chunkLoaderBlockEntity.get(), blockPos, blockState);
    }
    //?}

    @Override
    public PlacedChunkLoader loadMyChunks$getChunkLoader() {
        return chunkLoader;
    }

    @Override
    protected void read(CompoundTag tag) {
        super.read(tag);
        if(owner != null) {
            tag.m_128362_("owner", owner);
        }
    }

    @Override
    protected void write(CompoundTag tag) {
        super.write(tag);
        if(tag.m_128441_("owner")) {
            setOwner(tag.m_128342_("owner"));
        }
    }

    @Override
    public void loadMyChunks$destroy() {
        if(f_58857_ instanceof ServerLevel) {
            ChunkDataManager.removeChunkLoader((ServerLevel) f_58857_,m_58899_(),chunkLoader);
        }
    }

    @Override
    public void validate(Level level) {
        MultiversioningHelper.serverLevel(level,sl->{
            if(chunkLoader == null) {
                chunkLoader = ChunkDataManager.computeChunkLoaderIfAbsent(sl,m_58899_(),PlacedChunkLoader.class, loader-> loader.getPosition().equals(m_58899_()),()-> new PlacedChunkLoader(m_58899_(),owner));
            }
        });
    }

    public void setOwner(UUID uuid) {
        UUID prev = this.owner;
        this.owner=uuid == null ? Util.f_137441_ : uuid;
        MultiversioningHelper.serverLevel(f_58857_,sl->{
            if(chunkLoader != null){
                this.chunkLoader.setOwner(uuid);
                ChunkDataManager.markChunkNotOwnedBy(sl,chunkLoader.getChunkPos().m_45588_(),prev);
                ChunkDataManager.markChunkOwnedBy(sl,chunkLoader.getChunkPos().m_45588_(), uuid);
            }
        });
    }
}
