package com.drathonix.loadmychunks.common.item;

import com.drathonix.loadmychunks.common.util.Message;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2561;

public class ItemHasTooltip extends ItemLMC {
    private final int nLines;

    public ItemHasTooltip(class_1793 properties, int nLines) {
        super(properties);
        this.nLines = nLines;
    }

    //? if <=1.20.5 {
    @Override
    public void method_7851(class_1799 itemStack, @Nullable class_1937 level, List<class_2561> list, class_1836 tooltipFlag) {
        super.method_7851(itemStack, level, list, tooltipFlag);
        for (int i = 0; i < nLines; i++) {
            list.add(Message.translatable(getTooltipTranslationKey(i)));
        }
    }
    //?}

    //? if >1.20.5 {
    /*@Override
    public void appendHoverText(ItemStack itemStack, TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
        super.appendHoverText(itemStack, tooltipContext, list, tooltipFlag);
        for (int i = 0; i < nLines; i++) {
            list.add(Message.translatable(getTooltipTranslationKey(i)));
        }
    }
    *///?}

    public String getTooltipTranslationKey(int k){
        //? if <=1.19.3 {
        return "tooltip." + class_2378.field_11142.method_10221(this).toString().replace(":",".") + "." + k;
        //?} else {
        /*return "tooltip." + BuiltInRegistries.ITEM.getKey(this).toString().replace(":",".") + "." + k;
        *///?}
    }
}
