/*
 * Decompiled with CFR 0.152.
 */
package com.drathonix.loadmychunks.common.item;

import com.drathonix.loadmychunks.common.config.LMCConfig;
import com.drathonix.loadmychunks.common.item.ItemHasTooltip;
import com.drathonix.loadmychunks.common.system.ChunkDataManager;
import com.drathonix.loadmychunks.common.system.ChunkDataModule;
import com.drathonix.loadmychunks.common.util.Message;
import com.drathonix.loadmychunks.common.util.MultiversioningHelper;
import com.mojang.authlib.GameProfile;
import java.util.Iterator;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ChunkPos;

public class ItemChunkometer
extends ItemHasTooltip {
    public ItemChunkometer(Item.Properties properties) {
        super(properties, 1);
    }

    @Override
    protected InteractionResult useOnCtx(UseOnContext useOnContext) {
        MultiversioningHelper.serverLevel(useOnContext.m_43725_(), sl -> {
            ServerPlayer player = (ServerPlayer)useOnContext.m_43723_();
            if (player == null) {
                return;
            }
            ChunkPos pos = new ChunkPos(player.m_142538_());
            ChunkDataModule cdm = ChunkDataManager.getOrCreateChunkData(sl, pos);
            if (!LMCConfig.lagometerNeedsChunkOwnership || player.m_20310_(2) || cdm.containsOwnedLoader(player.m_142081_())) {
                MutableComponent response = Message.styled(Message.translatable("loadmychunks.chunkinfo.line1", pos.f_45578_, pos.f_45579_), ChatFormatting.WHITE, true, false);
                Message.send(player, (Component)response);
                response = Message.styled(Message.empty(), ChatFormatting.AQUA, false, false);
                response = cdm.onCooldown() ? Message.append(response, (Component)Message.translatable("loadmychunks.chunkinfo.line2.overticked", new Object[0])) : (cdm.getLoadState().shouldLoad() ? (cdm.getLoadState().shouldForceEntities() ? Message.append(response, (Component)Message.translatable("loadmychunks.chunkinfo.line2.forced.entity_ticking", new Object[0])) : Message.append(response, (Component)Message.translatable("loadmychunks.chunkinfo.line2.forced", new Object[0]))) : Message.append(response, (Component)Message.translatable("loadmychunks.chunkinfo.line2.notforced", new Object[0])));
                response = Message.append(response, "\n");
                response = Message.append(response, (Component)Message.translatable("loadmychunks.chunkinfo.line3", cdm.getTickTimer().getDuration()));
                StringBuilder csl = new StringBuilder();
                Iterator<UUID> iterator = cdm.getPlayerOwners().iterator();
                while (iterator.hasNext()) {
                    UUID u = iterator.next();
                    Optional profile = MultiversioningHelper.enforceOptional(sl.m_142572_().m_129927_().m_11002_(u));
                    if (profile.isPresent()) {
                        csl.append(((GameProfile)profile.get()).getName());
                    } else {
                        csl.append(u.toString());
                    }
                    if (!iterator.hasNext()) continue;
                    csl.append(", ");
                }
                if (!cdm.getLoaders().isEmpty()) {
                    response = Message.append(response, "\n");
                    response = Message.append(response, (Component)Message.translatable("loadmychunks.chunkinfo.line4", cdm.getLoaders().size(), csl.toString()));
                    if (cdm.onCooldown()) {
                        response = Message.append(response, "\n");
                        response = Message.append(response, (Component)Message.translatable("loadmychunks.chunkinfo.line5", cdm.getDisabledPeriod().getTimeRemaining() / 1000L));
                    }
                }
                Message.send(player, (Component)response);
            } else {
                Message.send(player, (Component)Message.styled(Message.translatable("loadmychunks.chunkinfo.need_ownership", new Object[0]), ChatFormatting.RED, false, false));
            }
        });
        return InteractionResult.SUCCESS;
    }
}

