/*
 * Decompiled with CFR 0.152.
 */
package com.drathonix.loadmychunks.common.mixin;

import com.drathonix.loadmychunks.common.bridge.IChunkMapMixin;
import com.drathonix.loadmychunks.common.bridge.IDistanceManagerMixin;
import com.mojang.datafixers.DataFixer;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import java.lang.reflect.Field;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.DistanceManager;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.entity.ChunkStatusUpdateListener;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.storage.LevelStorageSource;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ChunkMap.class})
public abstract class MixinChunkMap
implements IChunkMapMixin {
    @Shadow
    @Final
    private Long2ObjectLinkedOpenHashMap<ChunkHolder> f_140129_;
    @Unique
    private IDistanceManagerMixin lmc$distanceManager;
    @Shadow
    @Final
    private ServerLevel f_140133_;

    @Shadow
    abstract boolean m_183879_(ChunkPos var1);

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    public void captureDistMan(ServerLevel arg, LevelStorageSource.LevelStorageAccess arg2, DataFixer dataFixer, StructureManager arg3, Executor executor, BlockableEventLoop arg4, LightChunkGetter arg5, ChunkGenerator arg6, ChunkProgressListener arg7, ChunkStatusUpdateListener arg8, Supplier supplier, int i, boolean bl, CallbackInfo ci) {
        for (Field declaredField : this.getClass().getDeclaredFields()) {
            if (!IDistanceManagerMixin.class.isAssignableFrom(declaredField.getType())) continue;
            try {
                declaredField.setAccessible(true);
                this.lmc$distanceManager = (IDistanceManagerMixin)declaredField.get(this);
                return;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public Long2ObjectLinkedOpenHashMap<ChunkHolder> lmc$getUpdatingChunkMap() {
        return this.f_140129_;
    }

    @Override
    public boolean lmc$playerDistCheck(ChunkPos pos) {
        return this.m_183879_(pos);
    }

    @Unique
    private boolean lmc$playerIsCloseEnoughForSpawning(ServerPlayer p_183752_, ChunkPos p_183753_) {
        if (p_183752_.m_5833_()) {
            return false;
        }
        double d0 = MixinChunkMap.lmc$euclideanDistanceSquared(p_183753_, (Entity)p_183752_);
        return d0 < 16384.0;
    }

    @Unique
    private static double lmc$euclideanDistanceSquared(ChunkPos p_140227_, Entity p_140228_) {
        double d0 = SectionPos.m_123223_((int)p_140227_.f_45578_) + 8;
        double d1 = SectionPos.m_123223_((int)p_140227_.f_45579_) + 8;
        double d2 = d0 - p_140228_.m_20185_();
        double d3 = d1 - p_140228_.m_20189_();
        return d2 * d2 + d3 * d3;
    }

    @Override
    public boolean lmc$inEntityTickingRange(long l) {
        return this.lmc$distanceManager.lmc$inEntityTickingRange(l);
    }

    @Override
    public DistanceManager lmc$getDistanceManager() {
        return (DistanceManager)this.lmc$distanceManager;
    }
}

