/*
 * Decompiled with CFR 0.152.
 */
package com.drathonix.loadmychunks.common.system.control;

import com.drathonix.loadmychunks.common.registry.custom.LoadStateRegistry;
import com.drathonix.loadmychunks.common.system.control.ILoadState;
import com.drathonix.loadmychunks.common.system.control.LoaderPower;
import com.drathonix.loadmychunks.common.util.ModResource;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum LoadStateEnum implements ILoadState
{
    DISABLED{

        @Override
        public boolean shouldLoad() {
            return false;
        }
    }
    ,
    TICKING,
    OVERTICKED{

        @Override
        public boolean shouldLoad() {
            return false;
        }
    }
    ,
    PERMANENT{

        @Override
        public boolean permanent() {
            return true;
        }
    }
    ,
    PERMANENTLY_DISABLED{

        @Override
        public boolean shouldLoad() {
            return false;
        }
    };

    public final Holder.Reference<ILoadState> holder = LoadStateRegistry.INSTANCE.m_203693_(this);

    @Override
    public Holder.Reference<ILoadState> getIntrusiveHolder() {
        return this.holder;
    }

    @Nullable
    public static LoadStateEnum fromInt(int i) {
        LoadStateEnum[] vals = LoadStateEnum.values();
        if (i >= 0 && i < vals.length) {
            return vals[i];
        }
        return null;
    }

    @Override
    public LoaderPower blockEntityTickingPower() {
        return this.shouldLoad() ? (this.permanent() ? LoaderPower.FORCED : LoaderPower.FORCED_MANAGED) : LoaderPower.DISABLED;
    }

    @Override
    public LoaderPower entityForcingPower() {
        return LoaderPower.DISABLED;
    }

    @Override
    public boolean shouldLoad() {
        return true;
    }

    @Override
    public boolean permanent() {
        return false;
    }

    @Override
    public boolean overrides(ILoadState state) {
        if (this.getSuperiorLoadState(state) == this) {
            return true;
        }
        return ILoadState.super.overrides(state);
    }

    @Override
    public ILoadState getSuperiorLoadState(ILoadState loadState) {
        if (loadState instanceof LoadStateEnum) {
            if (this.ordinal() > ((LoadStateEnum)loadState).ordinal()) {
                return this;
            }
            return loadState;
        }
        return ILoadState.super.getSuperiorLoadState(loadState);
    }

    public ResourceLocation getResourceLocation() {
        return ModResource.of(this.name().toLowerCase());
    }

    @Override
    public int id() {
        return this.ordinal();
    }
}

