/*
 * Decompiled with CFR 0.152.
 */
package com.drathonix.loadmychunks.common.util;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.TranslatableComponent;

public class BoolArgument
implements ArgumentType<Boolean> {
    private static final Dynamic2CommandExceptionType INVALID_BOOL = new Dynamic2CommandExceptionType((found, constants) -> new TranslatableComponent("commands.loadmychunks.arguments.bool.invalid", new Object[]{constants, found}));
    private static final List<String> examples = new ArrayList<String>();

    public static BoolArgument boolArgument() {
        return new BoolArgument();
    }

    public Boolean parse(StringReader reader) throws CommandSyntaxException {
        String name = reader.readUnquotedString();
        try {
            return Boolean.parseBoolean(name) || name.equalsIgnoreCase("ON");
        }
        catch (Throwable e) {
            throw INVALID_BOOL.createWithContext((ImmutableStringReader)reader, (Object)name, (Object)this.getExamples().toString());
        }
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.m_82970_(this.getExamples(), (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return examples;
    }

    static {
        examples.add("TRUE");
        examples.add("FALSE");
        examples.add("ON");
        examples.add("OFF");
    }
}

