/*
 * Decompiled with CFR 0.152.
 */
package com.drathonix.loadmychunks.forge.integ;

import com.drathonix.loadmychunks.common.block.blockentity.BlockEntityChunkLoader;
import com.drathonix.loadmychunks.common.block.blockentity.BlockEntityLagometer;
import com.drathonix.loadmychunks.common.integ.cct.CCTRegistryContent;
import com.drathonix.loadmychunks.common.integ.cct.peripheral.ChunkLoaderPeripheral;
import com.drathonix.loadmychunks.common.integ.cct.peripheral.LagometerPeripheral;
import com.drathonix.loadmychunks.common.integ.cct.turtle.TurtleChunkLoaderUpgrade;
import com.drathonix.loadmychunks.common.registry.FakeRegistrySupplier;
import com.drathonix.loadmychunks.common.registry.LMCContent;
import dan200.computercraft.api.turtle.TurtleUpgradeSerialiser;
import dan200.computercraft.shared.Capabilities;
import dev.architectury.registry.registries.RegistrySupplier;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.DeferredRegister;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CCTForge {
    public static DeferredRegister<TurtleUpgradeSerialiser<?>> turtleUpgrades = DeferredRegister.create((ResourceKey)TurtleUpgradeSerialiser.REGISTRY_ID, (String)"loadmychunks");
    private static final ResourceLocation PERIPHERAL = new ResourceLocation("computercraft", "peripheral");

    @SubscribeEvent
    public static void registerCapabilities(AttachCapabilitiesEvent<BlockEntity> event) {
        if (event.getObject() instanceof BlockEntityChunkLoader) {
            final BlockEntityChunkLoader becl = (BlockEntityChunkLoader)event.getObject();
            event.addCapability(PERIPHERAL, new ICapabilityProvider(){

                @NotNull
                public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction arg) {
                    return Capabilities.CAPABILITY_PERIPHERAL.orEmpty(capability, LazyOptional.of(() -> new ChunkLoaderPeripheral(becl.m_58899_(), becl.m_58904_(), becl.loadMyChunks$getChunkLoader())));
                }
            });
        }
        if (event.getObject() instanceof BlockEntityLagometer) {
            final BlockEntityLagometer bel = (BlockEntityLagometer)event.getObject();
            event.addCapability(PERIPHERAL, new ICapabilityProvider(){

                @NotNull
                public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction arg) {
                    return Capabilities.CAPABILITY_PERIPHERAL.orEmpty(capability, LazyOptional.of(() -> new LagometerPeripheral(bel.m_58899_(), bel.m_58904_())));
                }
            });
        }
    }

    public static void init(IEventBus meb) {
        LMCContent.chunkLoaderBlockMap.forEach((color, supplier) -> {
            TurtleChunkLoaderUpgrade tclu = new TurtleChunkLoaderUpgrade((RegistrySupplier<Block>)supplier);
            FakeRegistrySupplier reg = new FakeRegistrySupplier(turtleUpgrades.register((String)(!color.isEmpty() ? color + "_" : "") + "chunk_loader", () -> TurtleUpgradeSerialiser.simple(key -> tclu)));
            CCTRegistryContent.registrySuppliers.add(reg);
        });
        turtleUpgrades.register(meb);
        MinecraftForge.EVENT_BUS.register(CCTForge.class);
        CCTRegistryContent.register();
    }

    public static void clientInit() {
        CCTRegistryContent.registerClient();
    }
}

