/*
 * Decompiled with CFR 0.152.
 */
package com.vicious.persist.mappify.registry;

import com.vicious.persist.annotations.Save;
import com.vicious.persist.except.CannotInitializeException;
import com.vicious.persist.except.InvalidAnnotationException;
import com.vicious.persist.mappify.reflect.ClassData;
import com.vicious.persist.mappify.reflect.FieldData;
import com.vicious.persist.util.ClassMap;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Initializers {
    private static final ClassMap<Supplier<?>> initializers = new ClassMap();

    public static <T> T ensureNotNull(Object value, Class<T> type) {
        if (value == null) {
            return Initializers.initialize(type);
        }
        return (T)value;
    }

    public static <T> T initialize(Class<T> type) {
        if (!initializers.containsKey(type)) {
            try {
                Constructor constructor = type.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                Initializers.register(type, () -> {
                    try {
                        return constructor.newInstance(new Object[0]);
                    }
                    catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                        throw new CannotInitializeException("Constructor for " + type.getName() + " threw an exception", e);
                    }
                });
            }
            catch (NoSuchMethodException e) {
                throw new CannotInitializeException("No default constructor exists for " + type.getName());
            }
        }
        return ((Supplier)initializers.get(type)).get();
    }

    public static <T> void register(Class<T> cls, Supplier<T> supplier) {
        initializers.put(cls, supplier);
    }

    public static <T> T enforce(Class<T> type, Object value) {
        if (value == null) {
            return Initializers.initialize(type);
        }
        if (value.getClass() != type) {
            return Initializers.initialize(type);
        }
        return (T)value;
    }

    public static boolean useCustomReconstructor(Class<?> type) {
        return ClassData.getClassData(type).hasInitializer();
    }

    public static <T> CustomConstructor<?> tryGenerateCustomReconstructorFor(Class<T> cls, ClassData data) {
        for (Constructor<?> declaredConstructor : cls.getDeclaredConstructors()) {
            Parameter parameter;
            Save save;
            Parameter[] parameterArray;
            int n;
            int n2;
            if (declaredConstructor.isAnnotationPresent(Save.Constructor.class)) {
                return Initializers.generateCustomReconstructorFor(declaredConstructor, data);
            }
            if (declaredConstructor.getParameterCount() <= 0 || (n2 = 0) >= (n = (parameterArray = declaredConstructor.getParameters()).length) || (save = (parameter = parameterArray[n2]).getAnnotation(Save.class)) == null) continue;
            return Initializers.generateCustomReconstructorFor(declaredConstructor, data);
        }
        return null;
    }

    private static <T> CustomConstructor<?> generateCustomReconstructorFor(Constructor<T> constructor, ClassData data) {
        ArrayList parameters = new ArrayList();
        if (constructor.isAnnotationPresent(Save.Constructor.class)) {
            Save.Constructor cnst = constructor.getAnnotation(Save.Constructor.class);
            if (cnst.value().length != constructor.getParameterCount()) {
                throw new InvalidAnnotationException("Constructor in " + String.valueOf(constructor.getDeclaringClass()) + " annotated with @Save.Constructor does not have the same number of parameters as the Save.Constructor$value() array.");
            }
            for (String name : cnst.value()) {
                FieldData<?> fieldData = data.getField(name);
                if (fieldData == null) {
                    throw new InvalidAnnotationException("No @Save field with name " + name + " for constructor parameter in " + String.valueOf(constructor.getDeclaringClass()) + " constructor.");
                }
                parameters.add(fieldData);
            }
        } else {
            for (Parameter parameter : constructor.getParameters()) {
                String name = Initializers.getName(parameter);
                FieldData<?> fieldData = data.getField(name);
                if (fieldData == null) {
                    throw new InvalidAnnotationException("No @Save field with name " + name + " for constructor parameter " + parameter.getName() + " in " + String.valueOf(constructor.getDeclaringClass()));
                }
                parameters.add(fieldData);
            }
        }
        constructor.setAccessible(true);
        return new CustomConstructor<Object>((map, converter) -> {
            if (map.size() < parameters.size()) {
                throw new CannotInitializeException("Provided map of arguments has " + map.size() + " arguments but needs to have " + parameters.size());
            }
            Object[] args = new Object[parameters.size()];
            block2: for (int i = 0; i < parameters.size(); ++i) {
                FieldData fieldData = (FieldData)parameters.get(i);
                for (String s : data.getKeysOfField(fieldData)) {
                    args[i] = map.get(s);
                    if (args[i] == null) continue;
                    args[i] = converter.convert(fieldData, i, args[i]);
                    continue block2;
                }
            }
            try {
                if (args.length < parameters.size()) {
                    // empty if block
                }
                return constructor.newInstance(args);
            }
            catch (Throwable e) {
                for (int i = 0; i < args.length; ++i) {
                    if (args[i] != null) continue;
                    throw new CannotInitializeException("Provided map is missing constructor argument: " + ((FieldData)parameters.get(i)).getName());
                }
                throw new CannotInitializeException(e);
            }
        }, (list, converter) -> {
            if (list.size() < parameters.size()) {
                throw new CannotInitializeException("Provided list of arguments has " + list.size() + " arguments but needs to have " + parameters.size());
            }
            try {
                Object[] args = new Object[list.size()];
                for (int i = 0; i < parameters.size(); ++i) {
                    FieldData fieldData = (FieldData)parameters.get(i);
                    args[i] = converter.convert(fieldData, i, list.get(i));
                }
                return constructor.newInstance(args);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new CannotInitializeException(e);
            }
        });
    }

    private static String getName(Parameter parameter) {
        Save anno = parameter.getAnnotation(Save.class);
        if (anno != null) {
            if (anno.value().isEmpty()) {
                if (parameter.isNamePresent()) {
                    return parameter.getName();
                }
                throw new InvalidAnnotationException("Cannot generate constructor, missing significant metadata providing argument names. This is critical to ordering. Mark all parameters with @Save(name = \"<name here>\")");
            }
            return anno.value();
        }
        if (parameter.isNamePresent()) {
            return parameter.getName();
        }
        throw new InvalidAnnotationException("Cannot generate constructor, missing significant metadata providing argument names. This is critical to ordering. Mark all parameters with @Save(name = \"<name here>\")");
    }

    public static boolean canGenerateInitializerFor(Class<?> cls) {
        for (Constructor<?> declaredConstructor : cls.getDeclaredConstructors()) {
            Parameter parameter;
            Save save;
            Parameter[] parameterArray;
            int n;
            int n2;
            if (declaredConstructor.isAnnotationPresent(Save.Constructor.class)) {
                return true;
            }
            if (declaredConstructor.getParameterCount() <= 0 || (n2 = 0) >= (n = (parameterArray = declaredConstructor.getParameters()).length) || (save = (parameter = parameterArray[n2]).getAnnotation(Save.class)) == null) continue;
            return true;
        }
        return false;
    }

    public static class CustomConstructor<T> {
        private final BiFunction<Map<Object, Object>, DynamicConverter<?>, T> mapConstructor;
        private final BiFunction<List<Object>, DynamicConverter<?>, T> listConstructor;

        private CustomConstructor(BiFunction<Map<Object, Object>, DynamicConverter<?>, T> mapConstructor, BiFunction<List<Object>, DynamicConverter<?>, T> listConstructor) {
            this.mapConstructor = mapConstructor;
            this.listConstructor = listConstructor;
        }

        public T constructMap(Map<Object, Object> map, DynamicConverter<?> converter) {
            return this.mapConstructor.apply(map, converter);
        }

        public T constructList(List<Object> list, DynamicConverter<?> converter) {
            return this.listConstructor.apply(list, converter);
        }

        public T construct(Object obj, DynamicConverter<?> converter) {
            LinkedList<Object> list = new LinkedList<Object>();
            list.add(obj);
            return this.constructList(list, converter);
        }
    }

    @FunctionalInterface
    public static interface DynamicConverter<T> {
        public Object convert(@NotNull FieldData<?> var1, int var2, @Nullable T var3);
    }
}

