package com.drathonix.loadmychunks.common;

import com.drathonix.loadmychunks.common.bridge.IInformable;
import com.drathonix.loadmychunks.common.registry.custom.LoadStateRegistry;
import com.drathonix.loadmychunks.common.util.MultiversioningHelper;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.context.CommandContext;
import com.drathonix.loadmychunks.common.config.LMCConfig;
import com.drathonix.loadmychunks.common.system.control.ILoadState;
import com.vicious.persist.io.writer.wrapped.WrappedObject;
import com.vicious.persist.mappify.Mappifier;
import com.vicious.persist.mappify.registry.Stringify;
import com.vicious.persist.shortcuts.PersistShortcuts;

//? if >=1.20.6
/*import com.drathonix.loadmychunks.common.integ.Integrations;*/
import com.drathonix.loadmychunks.common.network.LagReadingPacket;
import com.drathonix.loadmychunks.common.network.LagReadingRequest;
import com.drathonix.loadmychunks.common.registry.LMCContent;
import com.drathonix.loadmychunks.common.system.ChunkDataManager;
import com.drathonix.loadmychunks.common.system.ChunkDataModule;
import com.drathonix.loadmychunks.common.system.control.LoadStateEnum;
import com.drathonix.loadmychunks.common.util.Brigadier;
import com.drathonix.loadmychunks.common.util.Message;
//? if <=1.16.5 {
/*import me.shedaniel.architectury.event.events.CommandRegistrationEvent;
import me.shedaniel.architectury.networking.NetworkManager;
*///?}
//? if >1.16.5 {
import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
//?}
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import java.util.List;
import java.util.Map;
//? if <=1.20.4
import com.drathonix.loadmychunks.common.util.ModResource;

/**
 * The main entry point class for the mod.
 */
public class LoadMyChunks {
	public static MinecraftServer server;
	public static final String MOD_ID = "loadmychunks";
	public static final Logger logger = LogManager.getLogger(MOD_ID);
	public static Level debugLevel = Level.DEBUG;
	public static boolean stopping = false;

	//? if <1.20.5
	public static class_2960 LAG_READING_PACKET_ID = ModResource.of("lag");

	/**
	 * Initializes the mod. Should not be called more than once.
	 */
	public static void init() {
		logger.info("Preparing to load your chunks...");
		LMCConfig.init();
		if(LMCConfig.zeroContent){
			logger.info("Plugin mode is enabled! Item and block registration steps will be skipped");
		}
		if(LMCConfig.useDebugLogging){
			logger.info("Changing to debug logging");
			debugLevel = Level.INFO;
			logger.info("Using Debug Logging");
		}
		CommandRegistrationEvent.EVENT.register(LoadMyChunks::registerCommands);
		modMode(()->{
			LoadMyChunks.logger.info("Adding LMC content.");
			LMCContent.init();
			logger.info("Content added.");
		});
		//? if <=1.20.5 {
		NetworkManager.registerReceiver(NetworkManager.Side.C2S, LAG_READING_PACKET_ID, ((buf, context) -> {
			class_1657 plr = context.getPlayer();
			MultiversioningHelper.serverLevel(plr,sl->{
				ChunkDataModule cdm = ChunkDataManager.getOrCreateChunkData(sl, plr.method_24515());
				//TODO: integrate permissions with LP
				if (!LMCConfig.lagometerNeedsChunkOwnership || plr.method_5687(2) || cdm.containsOwnedLoader(plr.method_5667())) {
					cdm.addRecipient((IInformable) plr);
				}
			});
		}));
		//?}
		//? if >1.20.5 {
		/*NetworkManager.registerReceiver(NetworkManager.Side.C2S, LagReadingRequest.TYPE,LagReadingRequest.STREAM_CODEC, LagReadingRequest::handleServer);
		Integrations.invokeServer(()->{
			NetworkManager.registerS2CPayloadType(LagReadingPacket.TYPE,LagReadingPacket.STREAM_CODEC);
		});
		*///?}
	}

	/**
	 * Called when the server instance is created.
	 * @param server the server instance
	 */
	public static void serverStarted(MinecraftServer server) {
		LoadMyChunks.stopping=false;
		LoadMyChunks.server = server;
	}

	/**
	 * Called when the server stops.
	 * @param server the server instance
	 */
	public static void serverStopped(MinecraftServer server) {
		ChunkDataManager.clear();
	}

	/**
	 * Controls whether debug features are enabled. Do not enable outside of dev.
	 * @return false
	 */
	public static boolean allowUsingDebugFeatures() {
		return false;
	}

	/**
	 * Command registration entry point
	 */
	//? <1.19 {
	public static void registerCommands(CommandDispatcher<class_2168> dispatcher, class_2170.class_5364 selection) {
	//?} else {
	/*public static void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext registry, Commands.CommandSelection selection) {
	*///?}
		dispatcher.register(Brigadier.admin(Brigadier.literal("loadmychunks",root->{
			root.add(Brigadier.executes(Brigadier.literal("forceload",forceLoad->{
				forceLoad.add(Brigadier.executes(Brigadier.bool("permanent",boolForceLoad->{
					boolForceLoad.add(Brigadier.executes(Brigadier.bool("entity_ticking",entityTickingForceLoad->{
						entityTickingForceLoad.add(Brigadier.executes(Brigadier.blockPos("pos",empty->{

						}),ctx->handleCMDForceload(ctx,ctx.getArgument("permanent",Boolean.class),ctx.getArgument("entity_ticking",Boolean.class),Brigadier.getBlockPos(ctx,"pos"))));
					}),ctx->handleCMDForceload(ctx,ctx.getArgument("permanent",Boolean.class),ctx.getArgument("entity_ticking",Boolean.class),null)));
				}),ctx->handleCMDForceload(ctx,ctx.getArgument("permanent",Boolean.class),false,null)));
			}),ctx->handleCMDForceload(ctx,true,false,null)));
			root.add(Brigadier.executes(Brigadier.literal("unforceload",unforceLoad->{
				unforceLoad.add(Brigadier.executes(Brigadier.bool("permanent",boolUnforceLoad->{
					boolUnforceLoad.add(Brigadier.executes(Brigadier.blockPos("pos",empty->{}),ctx->handleCMDUnforceload(ctx,ctx.getArgument("permanent",Boolean.class),Brigadier.getBlockPos(ctx,"pos"))));
				}),ctx->handleCMDUnforceload(ctx,ctx.getArgument("permanent",Boolean.class),null)));
			}),ctx->handleCMDUnforceload(ctx,false,null)));
			root.add(Brigadier.literal("config",config->{
				config.add(Brigadier.string("path",pathcmd->{
					pathcmd.add(Brigadier.executes(Brigadier.string("value",empty->{}),ctx->{
						String path = ctx.getArgument("path",String.class);
						String value = ctx.getArgument("value",String.class);
						Map<Object,Object> map = Mappifier.DEFAULT.mappify(LMCConfig.class).unwrap();
						String[] splitPath = path.split("/");
						Object o = map;
						for (int i = 0; i < splitPath.length-1; i++) {
							String s = splitPath[i];
							if(o instanceof WrappedObject){
								o = ((WrappedObject) o).object;
							}

							if(o instanceof Map){
								o = map.get(s);
								if(o == null){
									Message.sendSystem(ctx,Message.translatable("commands.loadmychunks.config.bad_path_not_found",s));
									return 0;
								}
							}
							else if(o instanceof List){
								List<?> list = (List<?>) o;
								try {
									o = list.get(Stringify.objectify(Integer.class, value));
								} catch (Throwable e) {
									Message.sendSystem(ctx,Message.translatable("commands.loadmychunks.config.invalid_integer" ,s));
									return 0;
								}
							}
						}
						String key = splitPath[splitPath.length-1];
						if(o instanceof Map){
							Map<Object,Object> m = (Map<Object,Object>) o;
							m.put(key,value);
						}
						if(o instanceof List){
							List<Object> l = (List<Object>) o;
							int k;
							try{
								k = Integer.parseInt(key);
							} catch (Throwable e) {
								Message.sendSystem(ctx,Message.translatable("commands.loadmychunks.config.invalid_integer",key));
								return 0;
							}
							l.set(k,value);
						}
						try{
							Mappifier.DEFAULT.unmappify(LMCConfig.class,map);
							PersistShortcuts.saveAsFile(LMCConfig.class);
						} catch (Throwable e) {
							Message.sendSystem(ctx,Message.translatable("commands.loadmychunks.config.invalid_value", value));
							return 0;
						}
						Message.sendSystem(ctx,Message.translatable("commands.loadmychunks.config.value_set",path, value));
						LMCConfig.postReload();
						Message.sendSystem(ctx,Message.translatable("commands.loadmychunks.config.reload_complete"));
						return 1;
					}));
				}));
			}));
			root.add(Brigadier.literal("list",list->{
				list.add(Brigadier.executes(Brigadier.literal("forced",empty->{}),ctx->{
					class_3218 level = Brigadier.getLevel(ctx);
					Message.sendSystem(ctx,Message.styled(Message.translatable("commands.loadmychunks.list.forceloaded.header"),class_124.field_1075,true,true));
					ChunkDataManager.getManager(level).getChunkDataModules().stream().filter(cdm-> cdm.getLoadState().shouldLoad()).forEach(cdm->{
						class_1923 pos = cdm.getPosition();
						class_2338 dest = Brigadier.centralized(pos,255);
						if(cdm.getLoadState().permanent()) {
							if (cdm.getLoadState().shouldForceEntities()) {
								Message.sendSystem(ctx, Message.clickCommand(Message.translatable("commands.loadmychunks.list.forceloaded.entry.permanent.entity_ticking", pos.field_9181, pos.field_9180), "/tp " + dest.method_10263() + " " + dest.method_10264() + " " + dest.method_10260()));
							}
							else{
								Message.sendSystem(ctx, Message.clickCommand(Message.translatable("commands.loadmychunks.list.forceloaded.entry.permanent", pos.field_9181, pos.field_9180), "/tp " + dest.method_10263() + " " + dest.method_10264() + " " + dest.method_10260()));

							}
						}
						else {
							if (cdm.getLoadState().shouldForceEntities()) {
								Message.sendSystem(ctx, Message.clickCommand(Message.translatable("commands.loadmychunks.list.forceloaded.entry.entity_ticking", pos.field_9181, pos.field_9180), "/tp " + dest.method_10263() + " " + dest.method_10264() + " " + dest.method_10260()));
							}
							else{
								Message.sendSystem(ctx, Message.clickCommand(Message.translatable("commands.loadmychunks.list.forceloaded.entry", pos.field_9181, pos.field_9180), "/tp " + dest.method_10263() + " " + dest.method_10264() + " " + dest.method_10260()));
							}
						}
					});
					return 0;
				}));
				list.add(Brigadier.executes(Brigadier.literal("overticked",empty->{}),ctx->{
					class_3218 level = Brigadier.getLevel(ctx);
					Message.sendSystem(ctx,Message.styled(Message.translatable("commands.loadmychunks.list.overticked.header"),class_124.field_1075,true,true));
					ChunkDataManager.getManager(level).getChunkDataModules().stream().filter(cdm-> cdm.getLoadState() == LoadStateEnum.OVERTICKED || cdm.getLoadState() == LoadStateEnum.PERMANENTLY_DISABLED).forEach(cdm->{
						class_1923 pos = cdm.getPosition();
						class_2338 dest = Brigadier.centralized(pos,255);
						if(cdm.getLoadState() == LoadStateEnum.PERMANENTLY_DISABLED) {
							Message.sendSystem(ctx,Message.clickCommand(Message.translatable("commands.loadmychunks.list.forceloaded.entry.permanent",pos.field_9181,pos.field_9180),"/tp " + dest.method_10263() + " " + dest.method_10264() + " " + dest.method_10260()));
						}
						else{
							Message.sendSystem(ctx,Message.clickCommand(Message.translatable("commands.loadmychunks.list.forceloaded.entry",pos.field_9181,pos.field_9180),"/tp " + dest.method_10263() + " " + dest.method_10264() + " " + dest.method_10260()));
						}
					});
					return 0;
				}));
			}));
			root.add(Brigadier.executes(Brigadier.literal("reload",empty->{}),ctx->{
				Message.sendSystem(ctx,Message.translatable("commands.loadmychunks.config.reload_started"));
				LMCConfig.reload();
				Message.sendSystem(ctx,Message.translatable("commands.loadmychunks.config.reload_complete"));
				return 1;
			}));
			root.add(Brigadier.executes(Brigadier.literal("awaken",awaken->{
				awaken.add(Brigadier.executes(Brigadier.blockPos("pos",empty->{}),ctx->handleCMDAwaken(ctx,Brigadier.getBlockPos(ctx,"pos"))));
			}),ctx->handleCMDAwaken(ctx,null)));
		})));
	}

	private static int handleCMDForceload(CommandContext<class_2168> ctx, boolean permanent, boolean entityTicking, @Nullable class_2338 bp){
		bp = Brigadier.defaultedPos(ctx,bp);
		class_1923 pos = new class_1923(bp);
		class_3218 level = Brigadier.getLevel(ctx);
		ChunkDataModule cdm = ChunkDataManager.getOrCreateChunkData(level,pos);
		ILoadState prev = cdm.defaultLoadState;
		cdm.defaultLoadState= permanent ? (entityTicking ? LoadStateRegistry.ENTITY_TICKING_PERMANENT : LoadStateEnum.PERMANENT) : (entityTicking ? LoadStateRegistry.PERMANENT : LoadStateEnum.TICKING);
		cdm.clearCooldowns();
		cdm.update();
		cdm.getLoadState().apply(level,pos,prev);
		if(permanent) {
			Message.sendSystem(ctx, Message.translatable("loadmychunks.command.forceload.set.permanent", pos.field_9181, pos.field_9180));
		} else {
			Message.sendSystem(ctx, Message.translatable("loadmychunks.command.forceload.set", pos.field_9181, pos.field_9180));
		}
		return 1;
	}

	private static int handleCMDUnforceload(CommandContext<class_2168> ctx, boolean ban, @Nullable class_2338 bp){
		bp = Brigadier.defaultedPos(ctx,bp);
		class_1923 pos = new class_1923(bp);
		class_3218 level = Brigadier.getLevel(ctx);
		ChunkDataModule cdm = ChunkDataManager.getOrCreateChunkData(level,pos);
		ILoadState prev = cdm.defaultLoadState;
		cdm.defaultLoadState=ban ? LoadStateEnum.PERMANENTLY_DISABLED : LoadStateEnum.DISABLED;
		cdm.update();
		cdm.getLoadState().apply(level,pos,prev);
		if(ban) {
			Message.sendSystem(ctx, Message.translatable("loadmychunks.command.forceload.unset.permanent", pos.field_9181, pos.field_9180));
		}
		else{
			Message.sendSystem(ctx, Message.translatable("loadmychunks.command.forceload.unset", pos.field_9181, pos.field_9180));
		}
		return 1;
	}

	private static int handleCMDAwaken(CommandContext<class_2168> ctx, @Nullable class_2338 bp){
		bp = Brigadier.defaultedPos(ctx,bp);
		class_1923 pos = new class_1923(bp);
		class_3218 level = Brigadier.getLevel(ctx);
		ChunkDataModule cdm = ChunkDataManager.getOrCreateChunkData(level,pos);
		if(cdm.onCooldown()) {
			cdm.clearCooldowns();
			Message.sendSystem(ctx, Message.translatable("loadmychunks.command.awaken.success", pos.field_9181, pos.field_9180));
		} else {
			Message.sendSystem(ctx, Message.translatable("loadmychunks.command.awaken.redundant", pos.field_9181, pos.field_9180));
		}
		return 1;
	}

	/**
	 * Executes code only if the mod is in mod mode.
	 * @param exec arbitrary runnable.
	 */
	public static void modMode(Runnable exec){
		if(!LMCConfig.zeroContent){
			exec.run();
		}
	}
}
