package com.drathonix.loadmychunks.common.mixin;

import com.drathonix.loadmychunks.common.bridge.ITickingTrackerMixin;
import com.drathonix.loadmychunks.common.system.control.ChunkForcer;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

import java.util.List;
import net.minecraft.class_3228;
import net.minecraft.class_4706;
import net.minecraft.class_6609;
import org.spongepowered.asm.mixin.Unique;

@Mixin(class_6609.class)

public class MixinTickingTracker implements ITickingTrackerMixin {
    @Shadow @Final private Long2ObjectOpenHashMap<class_4706<class_3228<?>>> tickets;

    @Override
    public boolean lmc$hasEntityForcingTicket(long chunkPos) {
        class_4706<class_3228<?>> tickets = this.tickets.get(chunkPos);
        if (tickets == null) {
            return false;
        }
        for (class_3228<?> ticket : tickets) {
            if(ticket.method_14283() <= ChunkForcer.ENTITY_TICKING_LEVEL){
                return true;
            }
        }
        return false;
    }
}
//?} else {
/*@Mixin(targets="net.minecraft.server.level.DistanceManager$ChunkTicketTracker")
public abstract class MixinTickingTracker implements ITickingTrackerMixin {

}
*///?}
