package com.drathonix.loadmychunks.common.system.loaders;


import com.drathonix.loadmychunks.common.registry.LoaderTypeKeys;
import org.jetbrains.annotations.NotNull;

import java.util.Objects;
import net.minecraft.class_1923;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3218;

public abstract class PhantomChunkLoader implements IChunkLoader{
    protected class_1923 chunkPos;
    public PhantomChunkLoader(){}
    public PhantomChunkLoader(class_1923 pos){
        this.chunkPos = pos;
    }

    @Override
    public @NotNull class_2487 save(@NotNull class_2487 tag) {
        tag.method_10544("l", chunkPos.method_8324());
        return tag;
    }

    @Override
    public void load(@NotNull class_2487 tag, class_3218 level) throws DoNotAddException {
        chunkPos = new class_1923(tag.method_10537("l"));
    }

    @Override
    public class_2960 getTypeId() {
        return LoaderTypeKeys.PHANTOM_LOADER;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PhantomChunkLoader that = (PhantomChunkLoader) o;
        return Objects.equals(chunkPos, that.chunkPos);
    }

    @Override
    public int hashCode() {
        return Objects.hash(chunkPos);
    }

    @Override
    public @NotNull class_1923 getChunkPos() {
        return chunkPos;
    }
}
