package com.drathonix.loadmychunks.common.util;

import com.mojang.brigadier.context.CommandContext;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2168;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * Multi-versioning abstraction utility class for Components/Chat
 */
public class Message {
    /**
     * Creates a translatable Component
     * @param key the translation key
     * @param args the translation arguments
     * @return a MutableComponent containing translatable contents.
     */
    public static @NotNull class_5250 translatable(@NotNull String key, Object... args) {
        //? if <1.18.3 {
        return new class_2588(key,args);
        //?}
        //? if >1.18.2 {
        /*return Component.translatable(key,args);
        *///?}
    }

    /**
     * Sends a system message to a player.
     * @param player the recipient.
     * @param message the message.
     */
    public static void send(@NotNull class_3222 player, @Nullable class_2561 message) {
        if(message == null){
            return;
        }
        //? if >1.18.2 {
        /*player.sendSystemMessage(message);
        *///?} else {
        player.method_9203(message, class_156.field_25140);
        //?}
    }

    /**
     * Sends a success message to a command source.
     * @param ctx the command context.
     * @param message the success message
     */
    public static void sendSuccess(@NotNull CommandContext<class_2168> ctx, @NotNull class_2561 message) {
        //? if <1.20.1 {
        ctx.getSource().method_9226(message,true);
        //?} else if >=1.20.1 && !forge {
        /*ctx.getSource().sendSuccess(()->message,true);
        *///?} else if >=1.20.1 && forge {
        /*ctx.getSource().sendSystemMessage(message);
        *///?}
    }

    /**
     * Styles a component.
     * @param component the component to style.
     * @param formatting the color
     * @param bold whether to bold the text.
     * @param underlined whether to underline the text.
     * @return the styled component.
     */
    public static @NotNull class_5250 styled(@NotNull class_5250 component, @NotNull class_124 formatting, boolean bold, boolean underlined) {
        return component.method_10862(class_2583.field_24360.method_10977(formatting).method_10982(bold).method_30938(underlined));
    }

    /**
     * Sends a system message to a command source.
     * @param ctx the command context.
     * @param component the message.
     */
    public static void sendSystem(@NotNull CommandContext<class_2168> ctx, @NotNull class_2561 component) {
        //? if <1.19.2 {
        sendSuccess(ctx,component);
        //?} else {
        /*ctx.getSource().sendSystemMessage(component);
        *///?}
    }

    /**
     * Sets the component on click to suggest a command.
     * @param component the component.
     * @param command the suggested command.
     * @return the component with the click command.
     */
    public static @NotNull class_5250 clickCommand(@NotNull class_5250 component, @NotNull String command) {
        return component.method_10862(component.method_10866().method_10958(new class_2558(class_2558.class_2559.field_11745,command)));
    }

    /**
     * Creates an empty component.
     * @return a new empty component.
     */
    public static class_5250 empty() {
        return literal("");
    }

    /**
     * Creates a literal text component.
     * @param text the text.
     * @return a Text Component
     */
    public static class_5250 literal(String text) {
        //? if <1.18.3 {
        return new class_2585(text);
         //?}
        //? if >1.18.2 {
        /*return Component.literal(text);
        *///?}
    }

    public static class_5250 append(@NotNull class_5250 m1, @NotNull class_2561 m2) {
        return m1.method_10852(m2);
    }

    public static class_5250 append(class_5250 m1, String str) {
        return m1.method_27693(str);
    }
}
