package com.drathonix.loadmychunks.common.util;

import com.drathonix.loadmychunks.common.system.control.ILoadState;
import com.mojang.authlib.GameProfile;
//? if >1.16.5 {
import com.mojang.datafixers.util.Either;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.class_3614;
import net.minecraft.class_4076;
import net.minecraft.class_4970;
import net.minecraft.class_6880;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

/**
 * Multi-versioning Utility Class for miscellaneous methods.
 */
public class MultiversioningHelper {
    /**
     * Creates a default properties object.
     * @return some properties.
     */
    public static @NotNull class_4970.class_2251 properties(String key) {
        //? if >=1.21.2 {
        /*return BlockBehaviour.Properties.of().requiresCorrectToolForDrops().setId(ResourceKey.create(Registries.BLOCK,ModResource.of(key)));
        *///?} else if >1.19.4 {
        /*return BlockBehaviour.Properties.of().requiresCorrectToolForDrops();
        *///?} else {
        return class_4970.class_2251.method_9637(class_3614.field_15914).method_29292();
        //?}
    }

    /**
     * Creates a default properties object with the strength and blastResistance provided.
     * @return some properties.
     */
    public static @NotNull class_4970.class_2251 properties(String key, float strength, float blastResistance) {
        return properties(key).method_9629(strength,blastResistance);
    }

    public static void serverLevel(class_2586 blockEntity, Consumer<class_3218> cons) {
        serverLevel(blockEntity.method_10997(), cons);
    }

    public static void serverLevel(class_1937 level, Consumer<class_3218> cons) {
        if(level instanceof class_3218){
            cons.accept((class_3218) level);
        }
    }

    public static boolean isRemoved(class_1297 entity) {
        //? if >1.16.5 {
        return entity.method_31481();
        //?} else {
        /*return entity.removed;
        *///?}
    }

    public static class_1923 chunkPosOf(class_1297 entity) {
        //? if >1.16.5 {
        return entity.method_31476();
        //?} else {
        /*return new ChunkPos(entity.xChunk, entity.zChunk);
        *///?}
    }

    public static void serverLevel(class_1297 arg, Consumer<class_3218> cons) {
        //? if >1.19.4 {
        /*Level l = arg.level();
        *///?} else {
        class_1937 l = arg.field_6002;
        //?}
        serverLevel(l, cons);
    }

    /**
     * Checks if the object is an optional and if not puts it in an optional. The expected output must not be of type {@literal Optional<Optional<?>>}
     * @param obj the possible optional.
     * @return an optional.
     * @param <T> the optional value type.
     */
    @SuppressWarnings("unchecked")
    public static <T> Optional<T> enforceOptional(@Nullable Object obj) {
        if(obj instanceof Optional){
            return (Optional<T>) obj;
        }
        else{
            return (Optional<T>) Optional.ofNullable(obj);
        }
    }

    public static <T> @Nullable T serverLevel(class_2586 blockEntity, Function<class_3218,T> func) {
        class_1937 l = blockEntity.method_10997();
        if(l instanceof class_3218){
            return func.apply((class_3218) l);
        }
        return null;
    }

    public static <T> T enforceValue(Object obj) {
        if(obj instanceof Optional<?>){
            return enforceValue((T)((Optional<?>) obj).get());
        }
        //? if >1.16.5 {
        else if(obj instanceof class_6880.class_6883<?>){
            return (T)((class_6880.class_6883<?>) obj).comp_349();
        }
        //?}
        else{
            return (T)obj;
        }
    }

    public static long chunkPosOfOld(class_1297 e) {
        return new class_1923(class_4076.method_18675((int)e.field_6038),class_4076.method_18675((int)e.field_5989)).method_8324();
    }
}
