/*
 * Decompiled with CFR 0.152.
 */
package com.drathonix.loadmychunks.common.block.blockentity;

import com.drathonix.loadmychunks.common.block.blockentity.BEBase;
import com.drathonix.loadmychunks.common.bridge.IDestroyable;
import com.drathonix.loadmychunks.common.registry.LMCContent;
import com.drathonix.loadmychunks.common.system.ChunkDataManager;
import com.drathonix.loadmychunks.common.system.loaders.IChunkLoader;
import com.drathonix.loadmychunks.common.system.loaders.IHasChunkloader;
import com.drathonix.loadmychunks.common.system.loaders.PlacedChunkLoader;
import com.drathonix.loadmychunks.common.util.MultiversioningHelper;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class BlockEntityChunkLoader
extends BEBase
implements IDestroyable,
IHasChunkloader {
    private PlacedChunkLoader chunkLoader;
    private UUID owner = Util.NIL_UUID;

    public BlockEntityChunkLoader(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)LMCContent.chunkLoaderBlockEntity.get(), blockPos, blockState);
    }

    @Override
    public PlacedChunkLoader loadMyChunks$getChunkLoader() {
        return this.chunkLoader;
    }

    @Override
    protected void read(CompoundTag tag) {
        super.read(tag);
        if (this.owner != null) {
            tag.putUUID("owner", this.owner);
        }
    }

    @Override
    protected void write(CompoundTag tag) {
        super.write(tag);
        if (tag.contains("owner")) {
            this.setOwner(tag.getUUID("owner"));
        }
    }

    @Override
    public void loadMyChunks$destroy() {
        if (this.level instanceof ServerLevel) {
            ChunkDataManager.removeChunkLoader((ServerLevel)this.level, this.getBlockPos(), (IChunkLoader)this.chunkLoader);
        }
    }

    @Override
    public void validate(Level level) {
        MultiversioningHelper.serverLevel(level, sl -> {
            if (this.chunkLoader == null) {
                this.chunkLoader = ChunkDataManager.computeChunkLoaderIfAbsent(sl, this.getBlockPos(), PlacedChunkLoader.class, loader -> loader.getPosition().equals((Object)this.getBlockPos()), () -> new PlacedChunkLoader(this.getBlockPos(), this.owner));
            }
        });
    }

    public void setOwner(UUID uuid) {
        UUID prev = this.owner;
        this.owner = uuid == null ? Util.NIL_UUID : uuid;
        MultiversioningHelper.serverLevel(this.level, sl -> {
            if (this.chunkLoader != null) {
                this.chunkLoader.setOwner(uuid);
                ChunkDataManager.markChunkNotOwnedBy(sl, this.chunkLoader.getChunkPos().toLong(), prev);
                ChunkDataManager.markChunkOwnedBy(sl, this.chunkLoader.getChunkPos().toLong(), uuid);
            }
        });
    }
}

