/*
 * Decompiled with CFR 0.152.
 */
package com.drathonix.loadmychunks.common.integ;

import dev.architectury.platform.Platform;
import java.lang.reflect.InvocationTargetException;

public class Integrations {
    public static void whenModLoaded(String modid, Runnable runnable) {
        if (Platform.isModLoaded((String)modid)) {
            runnable.run();
        }
    }

    public static void invokeWhenLoaded(String modid, String cls, String method, Class<?>[] params, Object ... vals) {
        Integrations.whenModLoaded(modid, () -> {
            try {
                Class.forName(cls).getMethod(method, params).invoke(null, vals);
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static void invokeServer(Runnable runnable) {
        if (Platform.getEnv().isDedicatedServer()) {
            runnable.run();
        }
    }
}

