/*
 * Decompiled with CFR 0.152.
 */
package com.drathonix.loadmychunks.common.system;

import com.drathonix.loadmychunks.common.bridge.IInformable;
import com.drathonix.loadmychunks.common.bridge.IServerLevelMixin;
import com.drathonix.loadmychunks.common.config.LMCConfig;
import com.drathonix.loadmychunks.common.registry.custom.LoadStateRegistry;
import com.drathonix.loadmychunks.common.registry.custom.LoaderTypeRegistry;
import com.drathonix.loadmychunks.common.system.ChunkDataManager;
import com.drathonix.loadmychunks.common.system.control.CombinedTimings;
import com.drathonix.loadmychunks.common.system.control.ILoadState;
import com.drathonix.loadmychunks.common.system.control.LoadStateEnum;
import com.drathonix.loadmychunks.common.system.control.LoaderPower;
import com.drathonix.loadmychunks.common.system.control.Period;
import com.drathonix.loadmychunks.common.system.loaders.DoNotAddException;
import com.drathonix.loadmychunks.common.system.loaders.IChunkLoader;
import com.drathonix.loadmychunks.common.system.loaders.IOwnable;
import com.drathonix.loadmychunks.common.system.loaders.PlacedChunkLoader;
import com.drathonix.loadmychunks.common.util.ModResource;
import com.drathonix.loadmychunks.common.util.MultiversioningHelper;
import com.drathonix.loadmychunks.common.util.ProtectedEntityTickList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.entity.PartEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChunkDataModule {
    private final ProtectedEntityTickList entities = new ProtectedEntityTickList();
    private final CombinedTimings chunkTickTimer = new CombinedTimings();
    private Period gracePeriod;
    private Period disabledPeriod;
    public ILoadState defaultLoadState;
    private ILoadState loadState = this.defaultLoadState = LoadStateEnum.DISABLED;
    private final Set<IChunkLoader> loaders = new HashSet<IChunkLoader>();
    private final ChunkPos position;
    private final Set<IInformable> recipients = new HashSet<IInformable>();
    private long nextGameTimeCheckTick = -1L;

    public ChunkDataModule(ChunkPos position) {
        this.position = position;
    }

    public ChunkDataModule(long position) {
        this(new ChunkPos(position));
    }

    public void load(CompoundTag tag, ServerLevel level) {
        if (tag.contains("grace")) {
            this.gracePeriod = new Period(tag.getLong("grace"));
        }
        if (tag.contains("disabled")) {
            this.disabledPeriod = new Period(tag.getLong("disabled"));
        }
        if (tag.contains("nextCheck")) {
            this.nextGameTimeCheckTick = tag.getLong("nextCheck");
        }
        this.loadState = this.defaultLoadState = LoadStateRegistry.fromCompound("default", tag, LoadStateRegistry.DISABLED);
        ListTag loaders = tag.getList("loaders", 10);
        for (Tag loader : loaders) {
            if (!(loader instanceof CompoundTag)) continue;
            CompoundTag ct = (CompoundTag)loader;
            LoaderTypeRegistry.INSTANCE.getOptional(ModResource.parse(ct.getString("type_id"))).ifPresent(obj -> {
                Object loaderInst = obj.create();
                try {
                    loaderInst.load(ct, level);
                    this.addLoader(level, (IChunkLoader)loaderInst);
                }
                catch (DoNotAddException doNotAddException) {
                    // empty catch block
                }
            });
        }
        if (this.loadState.shouldLoad()) {
            this.startGrace();
        }
    }

    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        if (this.gracePeriod != null) {
            tag.putLong("grace", this.gracePeriod.getEnd());
        }
        if (this.disabledPeriod != null) {
            tag.putLong("disabled", this.disabledPeriod.getEnd());
        }
        tag.putLong("nextCheck", this.nextGameTimeCheckTick);
        ListTag loaders = new ListTag();
        for (IChunkLoader loader : this.loaders) {
            if (!loader.shouldPersist()) continue;
            CompoundTag data = new CompoundTag();
            data.putString("type_id", loader.getTypeId().toString());
            data = loader.save(data);
            loaders.add((Object)data);
        }
        tag.put("loaders", (Tag)loaders);
        this.defaultLoadState.putCompound("default", tag);
        return tag;
    }

    public boolean addLoader(ServerLevel level, @NotNull IChunkLoader loader) {
        this.loaders.add(loader);
        ILoadState previous = this.loadState;
        this.loadState = this.onCooldown() ? LoadStateEnum.OVERTICKED : loader.getActiveState().getSuperiorLoadState(this.loadState);
        this.nextGameTimeCheckTick = -1L;
        if (loader instanceof IOwnable) {
            // empty if block
        }
        return previous != this.loadState;
    }

    public boolean removeLoader(ServerLevel level, @NotNull IChunkLoader loader) {
        if (loader.hasExtensions()) {
            loader.getExtensionChunkLoaders().recompute(loader.getExtensionClass(), -1, null);
        }
        this.loaders.remove(loader);
        ILoadState previous = this.loadState;
        this.update();
        this.nextGameTimeCheckTick = -1L;
        if (loader instanceof IOwnable && !this.getAllOwners().contains(((IOwnable)((Object)loader)).getOwner())) {
            ChunkDataManager.markChunkNotOwnedBy(level, this.position.toLong(), ((IOwnable)((Object)loader)).getOwner());
        }
        return previous != this.loadState;
    }

    public void update() {
        this.loadState = this.defaultLoadState;
        if (!this.onCooldown()) {
            for (IChunkLoader loader : this.loaders) {
                this.loadState = loader.getActiveState().getSuperiorLoadState(this.loadState);
                if (this.loadState.blockEntityTickingPower() != LoaderPower.FORCED) continue;
                break;
            }
        } else {
            this.loadState = LoadStateEnum.OVERTICKED;
            this.gracePeriod = null;
        }
    }

    @NotNull
    public CombinedTimings getTickTimer() {
        return this.chunkTickTimer;
    }

    public boolean isOverticked() {
        return this.chunkTickTimer.durationExceeds(LMCConfig.msPerChunk);
    }

    @Nullable
    public Period getGracePeriod() {
        return this.gracePeriod;
    }

    @Nullable
    public Period getDisabledPeriod() {
        return this.disabledPeriod;
    }

    @NotNull
    public ILoadState getLoadState() {
        return this.loadState;
    }

    @NotNull
    public Set<IChunkLoader> getLoaders() {
        return this.loaders;
    }

    public boolean shouldUseTimings() {
        return !this.recipients.isEmpty() || this.shouldApplyTimings();
    }

    public boolean shouldApplyTimings() {
        return this.loadState.blockEntityTickingPower().isManaged() && !this.inGrace();
    }

    public boolean isPermaLoaded() {
        return this.loadState.shouldLoad() && this.loadState.permanent();
    }

    public void startGrace() {
        this.gracePeriod = Period.after(TimeUnit.SECONDS.toMillis(LMCConfig.reloadGracePeriod));
    }

    public void startShutoff() {
        this.loadState = LoadStateEnum.OVERTICKED;
        this.disabledPeriod = Period.after(TimeUnit.SECONDS.toMillis(LMCConfig.delayBeforeReload));
    }

    public boolean onCooldown() {
        return this.disabledPeriod != null && !this.disabledPeriod.hasEnded();
    }

    public boolean inGrace() {
        return this.gracePeriod != null && !this.gracePeriod.hasEnded();
    }

    @NotNull
    public ChunkPos getPosition() {
        return this.position;
    }

    public boolean containsOwnedLoader(@NotNull UUID uuid) {
        for (IChunkLoader loader : this.loaders) {
            if (!(loader instanceof IOwnable) || !uuid.equals(((IOwnable)((Object)loader)).getOwner())) continue;
            return true;
        }
        return false;
    }

    public void addRecipient(IInformable informable) {
        this.recipients.add(informable);
    }

    public void removeRecipient(IInformable informable) {
        this.recipients.remove(informable);
    }

    public void inform() {
        Iterator<IInformable> iterator = this.recipients.iterator();
        float frac = this.chunkTickTimer.getLagFraction();
        while (iterator.hasNext()) {
            IInformable informable = iterator.next();
            informable.lmc$informLagFrac(frac);
            if (informable instanceof BlockEntity && ((BlockEntity)informable).isRemoved()) {
                iterator.remove();
            }
            if (!(informable instanceof Entity) || ((Entity)informable).chunkPosition().toLong() == this.position.toLong()) continue;
            iterator.remove();
        }
    }

    public Set<@NotNull UUID> getPlayerOwners() {
        HashSet<UUID> owners = new HashSet<UUID>();
        for (IChunkLoader loader : this.loaders) {
            if (!(loader instanceof IOwnable) || !((IOwnable)((Object)loader)).hasOwner()) continue;
            owners.add(((IOwnable)((Object)loader)).getOwner());
        }
        return owners;
    }

    public Set<@Nullable UUID> getAllOwners() {
        HashSet<UUID> owners = new HashSet<UUID>();
        for (IChunkLoader loader : this.loaders) {
            if (!(loader instanceof IOwnable)) continue;
            owners.add(((IOwnable)((Object)loader)).getOwner());
        }
        return owners;
    }

    public void clearCooldowns() {
        this.disabledPeriod = null;
        this.gracePeriod = null;
    }

    public boolean shouldPersist() {
        return this.defaultLoadState != LoadStateEnum.DISABLED || this.loadState.permanent() || !this.loaders.isEmpty();
    }

    public long getCooldownTime() {
        return this.onCooldown() ? this.getDisabledPeriod().getTimeRemaining() : 0L;
    }

    public void updateChunkLoadState(@NotNull ServerLevel level, @NotNull ILoadState previous) {
        if (this.getLoadState().shouldLoad()) {
            this.startGrace();
        }
        this.getLoadState().apply(level, this.position.toLong(), previous);
    }

    @Nullable
    public PlacedChunkLoader getChunkLoaderAt(BlockPos blockPos) {
        for (IChunkLoader loader : this.loaders) {
            if (!(loader instanceof PlacedChunkLoader) || !((PlacedChunkLoader)loader).getPosition().equals((Object)blockPos)) continue;
            return (PlacedChunkLoader)loader;
        }
        return null;
    }

    public void preTick(ServerLevel level) {
        if (LMCConfig.cost.enabled && level.getGameTime() >= this.nextGameTimeCheckTick) {
            boolean doStateUpdateCheck = false;
            for (IChunkLoader loader : this.loaders) {
                ILoadState pre = loader.getActiveState();
                loader.timingsCheck(level, this, level.getGameTime());
                if (pre == loader.getActiveState()) continue;
                doStateUpdateCheck = true;
            }
            if (doStateUpdateCheck) {
                this.consumeLoadState(previous -> this.update(() -> this.updateChunkLoadState(level, (ILoadState)previous)));
            }
        }
    }

    public void update(Runnable onChange) {
        ILoadState pre = this.loadState;
        this.update();
        if (pre != this.loadState) {
            onChange.run();
        }
    }

    public void updateCheckTime(long time) {
        this.nextGameTimeCheckTick = time;
    }

    public void consumeLoadState(Consumer<ILoadState> consumer) {
        consumer.accept(this.loadState);
    }

    public void tickEntities(ServerLevel sl, ProfilerFiller profilerfiller) {
        boolean applyTimings = this.shouldApplyTimings();
        boolean useTimings = applyTimings || this.shouldUseTimings();
        IServerLevelMixin mixin = (IServerLevelMixin)sl;
        if (useTimings) {
            this.getTickTimer().startEntities();
        }
        this.entities.forEach(entity -> {
            if (!MultiversioningHelper.isRemoved(entity) && !sl.tickRateManager().isEntityFrozen(entity)) {
                if (mixin.lmc$shouldDiscardEntity((Entity)entity)) {
                    entity.discard();
                } else {
                    profilerfiller.push("checkDespawn");
                    entity.checkDespawn();
                    profilerfiller.pop();
                    Entity vehicle = entity.getVehicle();
                    if (vehicle != null) {
                        if (!MultiversioningHelper.isRemoved(vehicle) && vehicle.hasPassenger(entity)) {
                            return;
                        }
                        entity.stopRiding();
                    }
                    profilerfiller.push("tick");
                    if (!(entity instanceof PartEntity)) {
                        sl.guardEntityTick(arg_0 -> ((ServerLevel)sl).tickNonPassenger(arg_0), entity);
                    }
                    profilerfiller.pop();
                }
            }
        });
        if (useTimings) {
            this.getTickTimer().endEntities();
        }
    }

    public void lmc$removeEntity(Entity entity) {
        this.entities.remove(entity);
    }

    public void lmc$addEntity(Entity entity) {
        this.entities.add(entity);
    }
}

