/*
 * Decompiled with CFR 0.152.
 */
package com.drathonix.loadmychunks.common.system.loaders;

import com.drathonix.loadmychunks.common.config.LMCConfig;
import com.drathonix.loadmychunks.common.registry.custom.LoadStateRegistry;
import com.drathonix.loadmychunks.common.system.ChunkDataManager;
import com.drathonix.loadmychunks.common.system.ChunkDataModule;
import com.drathonix.loadmychunks.common.system.control.ILoadState;
import com.drathonix.loadmychunks.common.system.loaders.DoNotAddException;
import com.drathonix.loadmychunks.common.system.loaders.IChunkPositioned;
import com.drathonix.loadmychunks.common.system.loaders.extension.ExtensionChunkLoaders;
import com.drathonix.loadmychunks.common.system.loaders.extension.IExtensionChunkLoader;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public interface IChunkLoader
extends IChunkPositioned {
    default public ILoadState getActiveState() {
        return this.getDefaultState();
    }

    default public ILoadState getDefaultState() {
        return LoadStateRegistry.TICKING;
    }

    default public ILoadState setDefaultState(ILoadState state) {
        throw new IllegalStateException("setDefaultState not implemented for this chunk loader");
    }

    default public void setActiveState(ILoadState state) {
    }

    default public boolean shouldPersist() {
        return true;
    }

    default public boolean supportsExtensions() {
        return false;
    }

    @Nullable
    default public ExtensionChunkLoaders getExtensionChunkLoaders() {
        return null;
    }

    default public boolean hasExtensions() {
        return this.getExtensionChunkLoaders() != null;
    }

    default public int getExtensionRange() {
        return 0;
    }

    default public void setExtensionRange(int range) {
    }

    @ApiStatus.NonExtendable
    default public boolean tryExtendBy(ServerLevel serverLevel, int amount) {
        int r = this.getExtensionRange();
        if (LMCConfig.maximumRangeExtensions < r + amount) {
            return false;
        }
        this.extend(serverLevel, amount + r);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.NonExtendable
    default public void extend(ServerLevel serverLevel, int range) {
        IChunkLoader iChunkLoader = this;
        synchronized (iChunkLoader) {
            this.setExtensionRange(range);
            ExtensionChunkLoaders extensions = this.getExtensionChunkLoaders();
            if (range > 0) {
                if (extensions == null) {
                    extensions = new ExtensionChunkLoaders(serverLevel, this);
                    this.setExtensionsMap(extensions);
                }
                extensions.recompute(this.getExtensionClass(), range, this.getExtensionFactory());
            } else if (extensions != null) {
                extensions.recompute(this.getExtensionClass(), 0, this.getExtensionFactory());
            }
        }
    }

    default public void setExtensionsMap(ExtensionChunkLoaders extensions) {
        throw new UnsupportedOperationException("Must be implemented by child class.");
    }

    default public ExtensionChunkLoaders.Factory<?> getExtensionFactory() {
        throw new UnsupportedOperationException("Must be implemented by child class.");
    }

    default public <T extends IExtensionChunkLoader<?>> Class<T> getExtensionClass() {
        throw new UnsupportedOperationException("Must be implemented by child class.");
    }

    @NotNull
    public CompoundTag save(@NotNull CompoundTag var1);

    public void load(@NotNull CompoundTag var1, ServerLevel var2) throws DoNotAddException;

    default public void postLoad(ServerLevel level) throws DoNotAddException {
    }

    public ResourceLocation getTypeId();

    default public boolean shouldConsumeItems() {
        return LMCConfig.cost.enabled;
    }

    @NotNull
    public BlockPos getItemSource();

    default public long getActivityEnd() {
        return -1L;
    }

    default public void setActivityEnd(long l) {
    }

    @ApiStatus.NonExtendable
    default public void timingsCheck(ServerLevel level, ChunkDataModule chunkDataModule, long gameTime) {
        if (!this.getDefaultState().shouldLoad()) {
            return;
        }
        long activityEnd = this.getActivityEnd();
        long timeRemaining = activityEnd - gameTime;
        long duration = LMCConfig.cost.getDurationFor(this.getDefaultState());
        if (duration / 10L >= timeRemaining && LMCConfig.consumeFuel(level, this.getItemSource())) {
            activityEnd = gameTime + Math.max(0L, timeRemaining) + duration * 20L;
            this.setActivityEnd(activityEnd);
            chunkDataModule.updateCheckTime(activityEnd - duration / 10L);
        }
        if ((timeRemaining = activityEnd - gameTime) <= 0L) {
            this.setActivityEnd(-1L);
        }
    }

    @ApiStatus.NonExtendable
    default public @Range(from=0L, to=0x7FFFFFFFL) int getExtensionCount() {
        return this.getExtensionChunkLoaders() != null ? this.getExtensionChunkLoaders().size() : 0;
    }

    default public boolean supportsEntityTicking() {
        return false;
    }

    @ApiStatus.NonExtendable
    default public boolean enableEntityTicking(ServerLevel level) {
        boolean changed;
        boolean bl = changed = this.setDefaultState(LoadStateRegistry.ENTITY_TICKING) != LoadStateRegistry.ENTITY_TICKING;
        if (changed) {
            Optional.ofNullable(this.getExtensionChunkLoaders()).ifPresent(ExtensionChunkLoaders::requestUpdates);
            ChunkDataManager.requestUpdate(level, this.getChunkPos());
        }
        return changed;
    }
}

