/*
 * Decompiled with CFR 0.152.
 */
package com.vicious.persist.io.parser;

import com.vicious.persist.except.ParserException;
import com.vicious.persist.io.parser.AssumedType;
import com.vicious.persist.io.parser.IParser;
import com.vicious.persist.io.parser.TokenView;
import com.vicious.persist.io.parser.enums.CommentType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ParserBase
implements IParser {
    protected CommentType commentState;
    protected TokenView view;

    protected void setup(TokenView view) {
        this.commentState = CommentType.NONE;
        this.view = view;
    }

    @Override
    public Map<String, Object> mappify(TokenView tokenView) {
        this.setup(tokenView);
        try {
            if (tokenView.isSafe() && tokenView.getNextToken() == '{') {
                tokenView.read();
                if (tokenView.isSafe()) {
                    tokenView.read();
                }
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            while (this.view.isSafe()) {
                if (!this.skipIrrelevantData()) {
                    this.view.read();
                    return map;
                }
                String key = this.readKey();
                if (!this.skipIrrelevantData()) {
                    this.view.read();
                    return map;
                }
                map.put(key, this.readValue());
            }
            return map;
        }
        catch (Throwable e) {
            throw new ParserException("Failed to parse map due to an error.", e);
        }
    }

    @Override
    public List<Object> listify(TokenView tokenView) {
        this.setup(tokenView);
        try {
            ArrayList<Object> list = new ArrayList<Object>();
            while (this.view.isSafe()) {
                if (!this.skipIrrelevantData()) {
                    this.view.read();
                    return list;
                }
                list.add(this.readValue());
            }
            return list;
        }
        catch (Throwable e) {
            throw new ParserException("Failed to parse list due to an error.", e);
        }
    }

    protected boolean skipIrrelevantData() {
        try {
            while (this.view.isSafe()) {
                if (!this.isEscaped()) {
                    this.updateCommentState();
                    if (this.inComment()) {
                        this.view.read();
                        continue;
                    }
                    char c = this.getCurrentToken();
                    if (c == ']' || c == '}') {
                        return false;
                    }
                    if (!this.isWhitespace(c) && c != ':' && c != '=' && c != ',' && !this.isNewline(c)) {
                        return true;
                    }
                }
                this.view.read();
            }
            return false;
        }
        catch (IOException e) {
            throw new ParserException("Failed to find key due to an error.", e);
        }
    }

    protected String readKey() {
        try {
            StringBuilder key = new StringBuilder();
            while (this.view.isSafe()) {
                if (this.isNameTerminus()) {
                    return this.unquote(key.toString().trim());
                }
                key.append(this.getCurrentToken());
                this.view.read();
            }
            return key.toString().trim();
        }
        catch (IOException e) {
            throw new ParserException("Failed to read key due to an error.", e);
        }
    }

    private String unquote(String str) {
        if (str.startsWith("\"") && str.endsWith("\"")) {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }

    protected Object readValue() {
        try {
            StringBuilder value = new StringBuilder();
            if (this.getCurrentToken() == '{') {
                ParserBase mapper = this.copy();
                this.view.read();
                return mapper.mappify(this.view);
            }
            if (this.getCurrentToken() == '[') {
                ParserBase collector = this.copy();
                this.view.read();
                return collector.listify(this.view);
            }
            AssumedType type = AssumedType.UNKNOWN.append(this.getCurrentToken());
            value.append(this.getCurrentToken());
            while (this.view.isSafe()) {
                this.view.read();
                if (!this.isEndOfValue()) {
                    value.append(this.getCurrentToken());
                    type = type.append(this.getCurrentToken());
                    continue;
                }
                return this.trimValue(value.toString(), type);
            }
            return this.trimValue(value.toString(), type);
        }
        catch (IOException e) {
            throw new ParserException("Failed to read value due to an error.", e);
        }
    }

    protected Object trimValue(String value, AssumedType type) {
        try {
            value = value.trim();
            return this.convertFromString(value, type);
        }
        catch (Exception e) {
            if (e instanceof ParserException) {
                throw e;
            }
            throw new ParserException("Failed to trim " + value + " due to an error.", e);
        }
    }

    protected Object convertFromString(String value, AssumedType type) {
        return value;
    }

    protected boolean isEndOfValue() {
        char current = this.getCurrentToken();
        return !this.isEscaped() && (this.isNewline(current) || current == ',' || current == '}' || current == ']');
    }

    protected boolean isNameTerminus() {
        char current = this.getCurrentToken();
        return !this.isEscaped() && current == '=' || current == ':';
    }

    protected boolean isEscaped() {
        return this.getLastToken() == '\\';
    }

    protected boolean isWhitespace(char current) {
        return Character.isWhitespace(current);
    }

    protected abstract ParserBase copy();

    @Override
    public TokenView getTokenView() {
        return this.view;
    }

    @Override
    public CommentType getCommentState() {
        return this.commentState;
    }

    @Override
    public void setCommentState(CommentType commentState) {
        this.commentState = commentState;
    }
}

