/*
 * Decompiled with CFR 0.152.
 */
package com.vicious.persist.io.writer.gon;

import com.vicious.persist.except.WriterException;
import com.vicious.persist.io.writer.IWriter;
import com.vicious.persist.io.writer.Separation;
import com.vicious.persist.io.writer.wrapped.WrappedObject;
import com.vicious.persist.mappify.registry.Stringify;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class GONWriter
implements IWriter {
    public static final GONWriter DEFAULT = new GONWriter();
    public static final GONWriter PRETTY_JSON = new GONWriter().quoteStrings(true).quoteChars(true).quoteNames(true).charQuote('\"').nameValueSeparator(':').includeMapBrackets(true).writeComments(false).equalsEntryPadding(0).alwaysWriteCommaBetweenEntries(true);
    public static final GONWriter UGLY = new GONWriter(PRETTY_JSON).useListValueSeparator(Separation.COMMA).useMapEntrySeparator(Separation.COMMA).putEndingBracketsOnNewline(false);
    public static final GONWriter JSON5 = new GONWriter(PRETTY_JSON).writeComments(true).useMultilineComments(false);
    private Separation listValueSeparator = Separation.NEWLINE;
    private Separation mapEntrySeparator = Separation.NEWLINE;
    private boolean alwaysWriteCommaBetweenEntries = false;
    private boolean putEndingBracketsOnNewline = true;
    private int tabWidth = 1;
    private int equalsExitPadding = 1;
    private int equalsEntryPadding = 1;
    private int commaPadding = 1;
    private boolean stringsAutomaticallyQuoted = true;
    private boolean quoteNames = true;
    private boolean charsAutomaticallyQuoted = true;
    private int commentLineWrap = 72;
    private boolean writeComments = true;
    private boolean useMultilineComments = true;
    private char charQuote = (char)39;
    private char nameValueSeparator = (char)61;
    private boolean includeMapBrackets = false;

    public GONWriter() {
    }

    public GONWriter(GONWriter original) {
        this.listValueSeparator = original.listValueSeparator;
        this.mapEntrySeparator = original.mapEntrySeparator;
        this.tabWidth = original.tabWidth;
        this.equalsExitPadding = original.equalsExitPadding;
        this.commaPadding = original.commaPadding;
        this.stringsAutomaticallyQuoted = original.stringsAutomaticallyQuoted;
        this.quoteNames = original.quoteNames;
        this.charsAutomaticallyQuoted = original.charsAutomaticallyQuoted;
        this.commentLineWrap = original.commentLineWrap;
        this.charQuote = original.charQuote;
        this.nameValueSeparator = original.nameValueSeparator;
        this.includeMapBrackets = original.includeMapBrackets;
        this.writeComments = original.writeComments;
        this.useMultilineComments = original.useMultilineComments;
        this.putEndingBracketsOnNewline = original.putEndingBracketsOnNewline;
        this.equalsEntryPadding = original.equalsEntryPadding;
        this.alwaysWriteCommaBetweenEntries = original.alwaysWriteCommaBetweenEntries;
    }

    public GONWriter alwaysWriteCommaBetweenEntries(boolean b) {
        this.alwaysWriteCommaBetweenEntries = b;
        return this;
    }

    public GONWriter quoteNames(boolean quoteNames) {
        this.quoteNames = quoteNames;
        return this;
    }

    public GONWriter includeMapBrackets(boolean b) {
        this.includeMapBrackets = b;
        return this;
    }

    private GONWriter putEndingBracketsOnNewline(boolean b) {
        this.putEndingBracketsOnNewline = b;
        return this;
    }

    public GONWriter useMultilineComments(boolean b) {
        this.useMultilineComments = b;
        return this;
    }

    public GONWriter equalsEntryPadding(int a) {
        this.equalsEntryPadding = a;
        return this;
    }

    public GONWriter writeComments(boolean b) {
        this.writeComments = b;
        return this;
    }

    public GONWriter quoteStrings(boolean setting) {
        this.stringsAutomaticallyQuoted = setting;
        return this;
    }

    private GONWriter charQuote(char c) {
        this.charQuote = c;
        return this;
    }

    private GONWriter nameValueSeparator(char c) {
        this.nameValueSeparator = c;
        return this;
    }

    public GONWriter quoteChars(boolean setting) {
        this.charsAutomaticallyQuoted = setting;
        return this;
    }

    public GONWriter useListValueSeparator(@NotNull Separation separation) {
        this.listValueSeparator = separation;
        return this;
    }

    public GONWriter useMapEntrySeparator(@NotNull Separation separation) {
        this.mapEntrySeparator = separation;
        return this;
    }

    public GONWriter useCommentLineWrap(int length) {
        this.commentLineWrap = length;
        return this;
    }

    public GONWriter useTabWidth(int width) {
        this.tabWidth = width;
        return this;
    }

    public GONWriter equalsExitPadding(int padding) {
        this.equalsExitPadding = padding;
        return this;
    }

    public GONWriter commaPadding(int padding) {
        this.commaPadding = padding;
        return this;
    }

    @Override
    public void write(@NotNull Map<? extends Object, Object> map, @NotNull OutputStream out) {
        if (this.includeMapBrackets) {
            try {
                this.writeValue(map, out, 0);
            }
            catch (IOException e) {
                throw new WriterException("Failed to write", e);
            }
        } else {
            this.write(map, out, 0);
        }
    }

    public void write(Map<? extends Object, Object> map, OutputStream out, int depth) {
        Iterator<? extends Object> keys = map.keySet().iterator();
        while (keys.hasNext()) {
            Object k = keys.next();
            Object v = map.get(k);
            try {
                String comment;
                Object value = WrappedObject.unwrap(v);
                if (this.writeComments && !(comment = WrappedObject.unwrapComment(v)).isEmpty()) {
                    this.writeComment(out, comment, depth);
                }
                if (this.mapEntrySeparator == Separation.COMMA && (value instanceof Collection || value instanceof Map)) {
                    out.write(10);
                }
                if (this.mapEntrySeparator == Separation.NEWLINE || value instanceof Map || value instanceof Collection) {
                    this.tabs(out, depth * this.tabWidth);
                }
                this.writeName(k, out);
                this.writeChar(out, ' ', this.equalsEntryPadding);
                out.write(this.nameValueSeparator);
                this.writeChar(out, ' ', this.equalsExitPadding);
                this.writeValue(value, out, depth);
                if (keys.hasNext() && (this.mapEntrySeparator == Separation.COMMA || this.alwaysWriteCommaBetweenEntries)) {
                    out.write(44);
                    this.writeChar(out, ' ', this.commaPadding);
                }
                if (this.mapEntrySeparator != Separation.NEWLINE && !(value instanceof Map) && !(value instanceof Collection)) continue;
                out.write(10);
            }
            catch (IOException e) {
                throw new WriterException("Failed to write.", e);
            }
        }
    }

    protected void writeName(Object value, OutputStream out) throws IOException {
        boolean insertQuotes = this.quoteNames;
        String str = Stringify.stringify(value);
        if (insertQuotes) {
            boolean bl = insertQuotes = !str.endsWith("\"") && !str.startsWith("\"");
        }
        if (insertQuotes) {
            out.write(34);
        }
        out.write(Stringify.stringify(value).getBytes(StandardCharsets.UTF_8));
        if (insertQuotes) {
            out.write(34);
        }
    }

    protected void writeValue(Object value, OutputStream out, int depth) throws IOException {
        if (value instanceof Map) {
            out.write(123);
            if (this.mapEntrySeparator == Separation.NEWLINE && !((Map)value).isEmpty()) {
                out.write(10);
            }
            this.write((Map)value, out, depth + 1);
            if (this.mapEntrySeparator == Separation.NEWLINE && !((Map)value).isEmpty()) {
                this.tabs(out, this.tabWidth * depth);
            }
            out.write(125);
            return;
        }
        if (value instanceof Collection) {
            out.write(91);
            if (this.listValueSeparator == Separation.NEWLINE && !((Collection)value).isEmpty()) {
                out.write(10);
            }
            this.writeCollection((Collection)value, out, depth + 1);
            if (this.listValueSeparator == Separation.NEWLINE && !((Collection)value).isEmpty()) {
                this.tabs(out, this.tabWidth * depth);
            }
            out.write(93);
            return;
        }
        if (value == null) {
            out.write("null".getBytes(StandardCharsets.UTF_8));
            return;
        }
        Object stringifiedObject = Stringify.stringify(value);
        if (this.stringsAutomaticallyQuoted && !this.shouldQuote(value) && !((String)stringifiedObject).startsWith("\"") && !((String)stringifiedObject).endsWith("\"")) {
            stringifiedObject = "\"" + (String)stringifiedObject + "\"";
        }
        if (this.charsAutomaticallyQuoted && value instanceof Character) {
            stringifiedObject = this.charQuote + (String)stringifiedObject + this.charQuote;
        }
        out.write(((String)stringifiedObject).getBytes(StandardCharsets.UTF_8));
    }

    private boolean shouldQuote(Object object) {
        return object instanceof Number || object instanceof Boolean || object instanceof Character;
    }

    private void tabs(OutputStream out, int n) throws IOException {
        this.writeChar(out, '\t', n);
    }

    private void writeCollection(Collection<Object> collection, OutputStream out, int depth) {
        Iterator<Object> values = collection.iterator();
        while (values.hasNext()) {
            Object v = values.next();
            try {
                Object value = WrappedObject.unwrap(v);
                String comment = WrappedObject.unwrapComment(v);
                if (!comment.isEmpty()) {
                    this.writeComment(out, comment, depth);
                }
                if (this.listValueSeparator == Separation.COMMA && (value instanceof Collection || value instanceof Map)) {
                    out.write(10);
                }
                if (this.listValueSeparator == Separation.NEWLINE || value instanceof Map || value instanceof Collection) {
                    this.writeChar(out, '\t', depth * this.tabWidth);
                }
                this.writeValue(value, out, depth);
                if (values.hasNext() && (this.listValueSeparator == Separation.COMMA || this.alwaysWriteCommaBetweenEntries)) {
                    out.write(44);
                    this.writeChar(out, ' ', this.commaPadding);
                }
                if (this.listValueSeparator != Separation.NEWLINE) continue;
                out.write(10);
            }
            catch (IOException e) {
                throw new WriterException("Failed to write.", e);
            }
        }
    }

    protected void writeComment(OutputStream out, String comment, int depth) throws IOException {
        boolean isMultiLine;
        int lines = comment.length() / this.commentLineWrap + 1;
        int start = 0;
        this.tabs(out, depth * this.tabWidth);
        boolean bl = isMultiLine = this.useMultilineComments && lines > 1;
        if (isMultiLine) {
            out.write("/* ".getBytes(StandardCharsets.UTF_8));
        }
        for (int i = 0; i < lines; ++i) {
            int end = Math.min(comment.length(), (i + 1) * this.commentLineWrap);
            if (i < lines - 1) {
                int j;
                int n = j = end >= comment.length() ? comment.length() - 1 : end;
                while (j >= 0) {
                    if (Character.isWhitespace(comment.charAt(j))) {
                        end = j;
                        break;
                    }
                    --j;
                }
            }
            Object line = comment.substring(start, end);
            if (i == lines - 1 && isMultiLine) {
                line = (String)line + "*/";
            }
            start = end;
            if (i > 0) {
                this.tabs(out, depth * this.tabWidth);
            }
            if (!isMultiLine) {
                out.write("// ".getBytes(StandardCharsets.UTF_8));
            } else if (i > 0) {
                out.write(" * ".getBytes(StandardCharsets.UTF_8));
            }
            out.write(((String)line).trim().getBytes(StandardCharsets.UTF_8));
            out.write(10);
        }
    }

    protected void writeChar(OutputStream out, char c, int times) throws IOException {
        for (int i = 0; i < times; ++i) {
            out.write(c);
        }
    }
}

