/*
 * Decompiled with CFR 0.152.
 */
package com.vicious.persist.mappify;

import com.vicious.persist.except.InvalidSavableElementException;
import com.vicious.persist.except.InvalidValueException;
import com.vicious.persist.except.NoValuePresentException;
import com.vicious.persist.io.writer.wrapped.WrappedObject;
import com.vicious.persist.io.writer.wrapped.WrappedObjectList;
import com.vicious.persist.io.writer.wrapped.WrappedObjectMap;
import com.vicious.persist.mappify.ClassToName;
import com.vicious.persist.mappify.Context;
import com.vicious.persist.mappify.reflect.ClassData;
import com.vicious.persist.mappify.reflect.FieldData;
import com.vicious.persist.mappify.reflect.TypeInfo;
import com.vicious.persist.mappify.registry.Initializers;
import com.vicious.persist.mappify.registry.Reserved;
import com.vicious.persist.mappify.registry.Stringify;
import com.vicious.persist.util.Boxing;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Mappifier {
    public static final Mappifier DEFAULT = new Mappifier();
    private final Initializers.DynamicConverter<?> converter = (field, index, object) -> this.unmappifyValue(field, null, field.objectified(), object, 0);
    private boolean applyCommentsOnReservedFields = false;
    private boolean forceC_NAME = false;

    public static Mappifier create() {
        return new Mappifier();
    }

    private Mappifier() {
    }

    public Mappifier applyCommentsOnReservedFields(boolean setting) {
        this.applyCommentsOnReservedFields = setting;
        return this;
    }

    public Mappifier forceC_NAME(boolean setting) {
        this.forceC_NAME = setting;
        return this;
    }

    public WrappedObjectMap mappify(Object object) {
        return this.mappify(Context.of(object));
    }

    private WrappedObjectMap mappify(Context context) {
        WrappedObjectMap output = new WrappedObjectMap();
        context.forEach(fieldData -> output.put(fieldData.getName(), this.mappify((FieldData<?>)fieldData, context, fieldData.objectified())));
        if (context.hasTransformations()) {
            output.put(Reserved.TRANSFORMER_VER, WrappedObject.of(context.getTransformerVer(), this.reservedComment()));
        }
        return output;
    }

    private WrappedObject mappify(FieldData<?> data, Context context, boolean objectifyStatics) {
        try {
            return this.mappifyValue(data, data.get(context), objectifyStatics, 0, data.saveData.description());
        }
        catch (Throwable t) {
            throw new InvalidSavableElementException("Could not mappify field " + data.getFieldName() + " in " + String.valueOf(context.getType()), t);
        }
    }

    private WrappedObject mappifyValue(TypeInfo info, Object value, boolean objectifyStatics, int typingIndex, String comment) {
        if (value == null) {
            return WrappedObject.of(null, comment);
        }
        if (this.shouldStoreAsReference(value, objectifyStatics)) {
            return this.mappifyAsReference(info, value, comment);
        }
        if (Context.of(value).hasMappifiableTraits()) {
            Class<?> trueClass;
            WrappedObjectMap map = this.mappify(value);
            if (value instanceof Enum) {
                map.put(Reserved.E_NAME, WrappedObject.of(((Enum)value).name()));
            }
            if ((trueClass = value.getClass()) != info.getType()) {
                map.put(Reserved.C_NAME, WrappedObject.of(ClassToName.getName(value.getClass(), this.forceC_NAME)));
            }
            return WrappedObject.of(map, comment);
        }
        if (info.isCollection()) {
            return WrappedObject.of(this.mappifyCollection(info, (Collection)value, objectifyStatics, typingIndex), comment);
        }
        if (info.isMap()) {
            return WrappedObject.of(this.mappifyMap(info, (Map)value, objectifyStatics, typingIndex), comment);
        }
        if (info.isArray()) {
            return WrappedObject.of(this.mappifyArray(info, value, objectifyStatics, typingIndex), comment);
        }
        return WrappedObject.of(value, comment);
    }

    private WrappedObject mappifyAsReference(TypeInfo info, Object value, String comment) {
        if (value instanceof Class) {
            if (info.getType() == Class.class) {
                return WrappedObject.of(ClassToName.getName((Class)value, this.forceC_NAME), comment);
            }
            WrappedObjectMap map = new WrappedObjectMap();
            map.put(Reserved.C_NAME, WrappedObject.of(ClassToName.getName(value.getClass(), this.forceC_NAME)));
            return WrappedObject.of(map, comment);
        }
        if (info.getType() == ((Enum)value).getDeclaringClass()) {
            return WrappedObject.of(value, comment);
        }
        WrappedObjectMap map = new WrappedObjectMap();
        map.put(Reserved.C_NAME, WrappedObject.of(ClassToName.getName(value.getClass(), this.forceC_NAME)));
        map.put(Reserved.E_NAME, WrappedObject.of(((Enum)value).name()));
        return WrappedObject.of(map, comment);
    }

    private WrappedObjectMap mappifyMap(TypeInfo info, Map<?, ?> map, boolean raw, int typingIndex) {
        Class<?> valueType = info.getTyping(typingIndex + 1);
        WrappedObjectMap out = new WrappedObjectMap();
        for (Object key : map.keySet()) {
            Object val = map.get(key);
            if (val == null) {
                out.put(key, WrappedObject.nullified());
                continue;
            }
            if (!valueType.isAssignableFrom(val.getClass())) {
                throw new InvalidSavableElementException("Typing does not match Map generics.");
            }
            out.put(key, this.mappifyValue(TypeInfo.cast(info, valueType), val, raw, typingIndex + 2, null));
        }
        return out;
    }

    private WrappedObjectList mappifyCollection(TypeInfo info, Collection<?> collection, boolean raw, int typingIndex) {
        Class<?> valueType = info.getTyping(typingIndex);
        WrappedObjectList out = new WrappedObjectList();
        for (Object obj : collection) {
            if (obj == null) {
                out.add(WrappedObject.nullified());
                continue;
            }
            if (!valueType.isAssignableFrom(obj.getClass())) {
                throw new InvalidSavableElementException("Typing does not match Collection generics. Received object of type " + String.valueOf(obj.getClass()) + " but expected " + String.valueOf(valueType));
            }
            out.add(this.mappifyValue(TypeInfo.cast(info, valueType), obj, raw, typingIndex + 1, null));
        }
        return out;
    }

    private WrappedObjectList mappifyArray(TypeInfo info, Object array, boolean raw, int typingIndex) {
        Class<?> valueType = info.getTyping(typingIndex);
        WrappedObjectList out = new WrappedObjectList();
        int len = Array.getLength(array);
        for (int i = 0; i < len; ++i) {
            Object obj = Array.get(array, i);
            if (obj == null) {
                out.add(WrappedObject.nullified());
                continue;
            }
            if (!Boxing.requireObjective(valueType).isAssignableFrom(obj.getClass())) {
                throw new InvalidSavableElementException("Typing does not match Array types. Received object of type " + String.valueOf(obj.getClass()) + " but expected " + String.valueOf(valueType));
            }
            out.add(this.mappifyValue(TypeInfo.cast(info, valueType), obj, raw, typingIndex + 1, null));
        }
        return out;
    }

    private Object mappifyClass(TypeInfo info, Object classObject, boolean raw) {
        Context internalContext = Context.of(classObject);
        if (!raw && internalContext.hasMappifiableTraits()) {
            WrappedObjectMap obj = this.mappify(internalContext);
            if (info.getType() != classObject) {
                obj.put(Reserved.C_NAME, WrappedObject.of(Stringify.stringify(classObject), this.reservedComment()));
            }
            return obj;
        }
        return classObject;
    }

    private String reservedComment() {
        return this.applyCommentsOnReservedFields ? "DO NOT EDIT" : "";
    }

    @NotNull
    public <T> T unmappifyThroughInit(@NotNull Class<T> type, Map<Object, Object> map) {
        ClassData data = ClassData.getClassData(type);
        if (data.hasInitializer()) {
            return (T)data.getInitializer().constructMap(map, this.converter);
        }
        T t = Initializers.initialize(type);
        this.unmappify(t, map);
        return t;
    }

    @NotNull
    public <T> T unmappifyThroughInit(@NotNull Class<T> type, List<Object> orderedArgs) {
        ClassData data = ClassData.getClassData(type);
        if (data.hasInitializer()) {
            return (T)data.getInitializer().constructList(orderedArgs, this.converter);
        }
        throw new IllegalArgumentException(String.valueOf(type) + " does not have a generated initializer");
    }

    @NotNull
    public <T> T unmappifyThroughInit(@NotNull Class<T> type, Object monoArg) {
        ClassData data = ClassData.getClassData(type);
        if (data.hasInitializer()) {
            return (T)data.getInitializer().construct(monoArg, this.converter);
        }
        throw new IllegalArgumentException(String.valueOf(type) + " does not have a generated initializer");
    }

    public void unmappify(Object writeTarget, WrappedObjectMap map) {
        this.unmappify(writeTarget, (Map<Object, Object>)map.unwrap());
    }

    public void unmappify(Object writeTarget, Map<Object, Object> map) {
        this.unmappify(Context.of(writeTarget), map);
    }

    private void unmappify(Context context, Map<Object, Object> map) {
        if (context.hasTransformations()) {
            context.transform(map);
        }
        Set<FieldData<?>> required = context.data.copyRequired(context);
        for (Object o : map.keySet()) {
            context.whenPresent(Stringify.stringify(o), fieldData -> {
                this.unmappify((FieldData<?>)fieldData, map.get(o), context);
                if (!required.isEmpty()) {
                    required.remove(fieldData);
                }
            });
        }
        if (!required.isEmpty()) {
            FieldData<?> zero = required.iterator().next();
            throw new NoValuePresentException("Did not find required value of key " + zero.getName() + " in the provided map!");
        }
    }

    private void unmappify(FieldData<?> data, Object parsedValue, Context context) {
        try {
            Object unmapped = this.unmappifyValue(data, data.get(context), data.objectified(), parsedValue, 0);
            data.set(context, unmapped);
        }
        catch (Throwable t) {
            throw new InvalidSavableElementException("Could not unmappify field " + data.getFieldName() + " in " + String.valueOf(context.getType()), t);
        }
    }

    private Object unmappifyValue(TypeInfo info, @Nullable Object currentValue, boolean objectifyStatics, Object parsedValue, int typingIndex) {
        if (parsedValue == null) {
            return null;
        }
        if (info.getType() == parsedValue.getClass()) {
            return parsedValue;
        }
        if (parsedValue instanceof Collection) {
            if (info.isCollection()) {
                return this.unmappifyCollection(info, (Collection)Initializers.ensureNotNull(currentValue, info.getType()), (Collection)parsedValue, objectifyStatics, typingIndex);
            }
            if (info.isArray()) {
                return this.unmappifyArray(info, (Collection)parsedValue, objectifyStatics, typingIndex);
            }
            throw new InvalidValueException("Parsed value is a Collection but the expected type is of " + String.valueOf(info.getType()) + " which cannot be converted to from a collection.");
        }
        if (parsedValue instanceof Map) {
            if (info.isMap()) {
                return this.unmappifyMap(info, (Map)Initializers.ensureNotNull(currentValue, info.getType()), (Map)parsedValue, objectifyStatics, typingIndex);
            }
            if (Initializers.useCustomReconstructor(info.getType())) {
                return ClassData.getClassData(info.getType()).getInitializer().constructMap((Map)parsedValue, this.converter);
            }
            Map map = (Map)parsedValue;
            if (map.containsKey(Reserved.C_NAME)) {
                info = TypeInfo.cast(info, ClassToName.get(map.get(Reserved.C_NAME).toString()));
            }
            currentValue = map.containsKey(Reserved.E_NAME) ? (!info.getType().isEnum() && info.getType().getSuperclass().isEnum() ? Enum.valueOf(info.getType().getSuperclass(), map.get(Reserved.E_NAME).toString()) : Enum.valueOf(info.getType(), map.get(Reserved.E_NAME).toString())) : Initializers.enforce(info.getType(), currentValue);
            if (this.shouldStoreAsReference(info, objectifyStatics)) {
                return currentValue;
            }
            if (Context.of(info.getType()).hasMappifiableTraits(info.getType() == Class.class)) {
                currentValue = Initializers.ensureNotNull(currentValue, info.getType());
                this.unmappify(currentValue, (Map<Object, Object>)((Map)parsedValue));
                return currentValue;
            }
            throw new InvalidValueException("Parsed value is a Map but the expected type is of " + String.valueOf(info.getType()) + " which cannot be converted to from a map.");
        }
        return Stringify.objectify(info.getType(), parsedValue.toString());
    }

    private Map<Object, Object> unmappifyMap(TypeInfo info, Map<Object, Object> currentValue, Map<?, ?> parsedMap, boolean raw, int typingIndex) {
        Class<?> keyType = info.getTyping(typingIndex);
        Class<?> valueType = info.getTyping(typingIndex + 1);
        currentValue.clear();
        for (Object key : parsedMap.keySet()) {
            Object val = parsedMap.get(key);
            currentValue.put(this.unmappifyValue(TypeInfo.cast(info, keyType), null, raw, key, typingIndex + 2), this.unmappifyValue(TypeInfo.cast(info, valueType), null, raw, val, typingIndex + 2));
        }
        return currentValue;
    }

    private Collection<?> unmappifyCollection(TypeInfo info, Collection<Object> currentValue, Collection<?> parsedCollection, boolean raw, int typingIndex) {
        Class<?> valueType = info.getTyping(typingIndex);
        currentValue.clear();
        for (Object obj : parsedCollection) {
            currentValue.add(this.unmappifyValue(TypeInfo.cast(info, valueType), null, raw, obj, typingIndex + 1));
        }
        return currentValue;
    }

    private Object unmappifyArray(TypeInfo info, Collection<?> parsedCollection, boolean raw, int typingIndex) {
        Class<?> valueType = info.getTyping(typingIndex);
        Object arrayOut = Array.newInstance(valueType, parsedCollection.size());
        int i = 0;
        for (Object obj : parsedCollection) {
            Boxing.arraySet(arrayOut, i, this.unmappifyValue(TypeInfo.cast(info, valueType), null, raw, obj, typingIndex + 1));
            ++i;
        }
        return arrayOut;
    }

    private boolean shouldStoreAsReference(TypeInfo info, boolean objectifyStatics) {
        if (info.getType() == Class.class || info.getType().isEnum()) {
            return !objectifyStatics;
        }
        return false;
    }

    private boolean shouldStoreAsReference(Object obj, boolean objectifyStatics) {
        if (obj instanceof Class || obj instanceof Enum) {
            return !objectifyStatics;
        }
        return false;
    }
}

