//? if computercraft {
package com.drathonix.loadmychunks.common.integ.cct.peripheral;

import com.drathonix.loadmychunks.common.system.ChunkDataManager;
import com.drathonix.loadmychunks.common.system.ChunkDataModule;
import com.drathonix.loadmychunks.common.system.loaders.IChunkLoader;
import dan200.computercraft.api.peripheral.IPeripheral;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChunkLoaderPeripheral extends AbstractChunkLoaderPeripheral {
    private final @NotNull class_2338 pos;
    private final @NotNull IChunkLoader loader;
    private final @NotNull class_3218 level;
    private final @NotNull ChunkDataModule cdm;

    public ChunkLoaderPeripheral(@NotNull class_2338 pos, @NotNull class_1937 level, @NotNull IChunkLoader loader){
        this.pos = pos;
        this.loader = loader;
        this.level=(class_3218)level;
        this.cdm = ChunkDataManager.getOrCreateChunkData(this.level,pos);
    }

    @Override
    public @NotNull IChunkLoader getChunkLoader() {
        return loader;
    }

    @Override
    public @NotNull ChunkDataModule getChunkDataModule() {
        return this.cdm;
    }

    @Override
    protected @NotNull class_3218 getLevel() {
        return level;
    }

    @Override
    protected @NotNull class_2338 getPosition() {
        return pos;
    }

    @Override
    public boolean equals(@Nullable IPeripheral other) {
        return false;
    }
}
//?}