//? if computercraft {
package com.drathonix.loadmychunks.common.integ.cct.peripheral;

import com.drathonix.loadmychunks.common.system.ChunkDataManager;
import com.drathonix.loadmychunks.common.system.ChunkDataModule;
import dan200.computercraft.api.peripheral.IPeripheral;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Objects;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3218;

public class LagometerPeripheral extends AbstractLagometerPeripheral {
    protected final @NotNull class_2338 pos;
    protected final @NotNull class_3218 level;
    private final @NotNull ChunkDataModule cdm;

    public LagometerPeripheral(@NotNull class_2338 pos, @NotNull class_1937 level){
        this.pos = pos;
        this.level = (class_3218)level;
        this.cdm = ChunkDataManager.getOrCreateChunkData(this.level,pos);
    }

    @Override
    public boolean equals(@Nullable IPeripheral other) {
        return equals((Object)other);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        LagometerPeripheral that = (LagometerPeripheral) o;
        return Objects.equals(pos, that.pos) && Objects.equals(level, that.level);
    }

    @Override
    public int hashCode() {
        return Objects.hash(pos, level);
    }

    @Override
    public @NotNull ChunkDataModule getChunkDataModule() {
        return this.cdm;
    }

    @Override
    protected @NotNull class_3218 getLevel() {
        return level;
    }

    @Override
    protected @NotNull class_2338 getPosition() {
        return pos;
    }
}
//?}