package com.drathonix.loadmychunks.common.system.control;

import com.drathonix.loadmychunks.common.bridge.IChunkMapMixin;
import java.util.Comparator;
import net.minecraft.class_1923;
import net.minecraft.class_3204;
import net.minecraft.class_3218;
import net.minecraft.class_3230;

/**
 * Handles the forcing of chunks using {@link net.minecraft.class_3228}s
 * @since 1.2.0
 * @author Jack Andersen
 */
public class ChunkForcer {
    // Putting this here for reference
    // Any level below or equal to 31 is entity ticking, 32 is block ticking, 33 is full but not loaded, 34+ is not full.
    // private static final int FULL_CHUNK_LEVEL = 33;
    public static final int BLOCK_TICKING_LEVEL = 32;
    public static final int ENTITY_TICKING_LEVEL = 31;

    public static final class_3230<class_1923> FORCED = class_3230.method_14291("lmc_forced", Comparator.comparingLong(class_1923::method_8324));
    public static final class_3230<class_1923> ENTITY = class_3230.method_14291("lmc_entity", Comparator.comparingLong(class_1923::method_8324));
    private synchronized static void addTicket(class_3204 manager, class_1923 pos, boolean entityTicking){
        //Remove the inverted ticket if it is present.
        removeTicket(manager,pos, !entityTicking);
        manager.method_17290(entityTicking ? ENTITY : FORCED, pos, entityTicking ? ENTITY_TICKING_LEVEL : BLOCK_TICKING_LEVEL, pos);
    }
    private synchronized static void removeTicket(class_3204 manager, class_1923 pos, boolean entityTicking){
        manager.method_20444(entityTicking ? ENTITY : FORCED, pos, entityTicking ? ENTITY_TICKING_LEVEL : BLOCK_TICKING_LEVEL, pos);
    }

    /**
     * Stops forcing a chunk using LMC chunk forcing.
     * @param level the level.
     * @param pos the chunk to force.
     * @param wasEntityTicking whether the chunk was previously entity ticking.
     */
    public static void unforceChunk(class_3218 level, class_1923 pos, boolean wasEntityTicking){
        removeTicket(((IChunkMapMixin)level.method_14178().field_17254).lmc$getDistanceManager(),pos,wasEntityTicking);
    }

    /**
     * Forces a chunk using LMC chunk forcing.
     * @param level the level.
     * @param pos the chunk to force.
     * @param doEntityTicking whether to enable entity ticking.
     */
    public static void forceChunk(class_3218 level, class_1923 pos, boolean doEntityTicking){
        addTicket(((IChunkMapMixin)level.method_14178().field_17254).lmc$getDistanceManager(),pos,doEntityTicking);
    }
}
