/*
 * Decompiled with CFR 0.152.
 */
package com.drathonix.loadmychunks.common.block.blockentity;

import com.drathonix.loadmychunks.common.block.BlockLagometer;
import com.drathonix.loadmychunks.common.block.blockentity.BEBase;
import com.drathonix.loadmychunks.common.bridge.IInformable;
import com.drathonix.loadmychunks.common.registry.LMCContent;
import com.drathonix.loadmychunks.common.system.ChunkDataManager;
import com.drathonix.loadmychunks.common.system.ChunkDataModule;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockEntityLagometer
extends BEBase
implements IInformable {
    private ChunkDataModule cdm;

    @Override
    public void validate(Level level) {
        super.validate(level);
        if (level instanceof ServerLevel) {
            this.cdm = ChunkDataManager.getOrCreateChunkData((ServerLevel)level, this.getBlockPos());
            this.cdm.addRecipient(this);
        }
    }

    public BlockEntityLagometer(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)LMCContent.lagometerBlockEntity.get(), blockPos, blockState);
    }

    @Override
    public void lmc$informLagFrac(float frac) {
        int currLag;
        BlockState blockState;
        int prevLag;
        if (!this.isRemoved() && (prevLag = ((Integer)(blockState = this.getBlockState()).getValue((Property)BlockLagometer.LAG)).intValue()) != (currLag = (int)(this.cdm.getTickTimer().getLagFraction() * 15.0f))) {
            this.level.setBlock(this.worldPosition, (BlockState)blockState.setValue((Property)BlockLagometer.LAG, (Comparable)Integer.valueOf(currLag)), 3);
        }
    }

    public void setRemoved() {
        super.setRemoved();
        if (this.cdm != null) {
            this.cdm.removeRecipient(this);
        }
    }
}

