/*
 * Decompiled with CFR 0.152.
 */
package com.drathonix.loadmychunks.common.system.loaders;

import com.drathonix.loadmychunks.common.registry.LoaderTypeKeys;
import com.drathonix.loadmychunks.common.system.loaders.DoNotAddException;
import com.drathonix.loadmychunks.common.system.loaders.IChunkLoader;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import org.jetbrains.annotations.NotNull;

public abstract class PhantomChunkLoader
implements IChunkLoader {
    protected ChunkPos chunkPos;

    public PhantomChunkLoader() {
    }

    public PhantomChunkLoader(ChunkPos pos) {
        this.chunkPos = pos;
    }

    @Override
    @NotNull
    public CompoundTag save(@NotNull CompoundTag tag) {
        tag.putLong("l", this.chunkPos.toLong());
        return tag;
    }

    @Override
    public void load(@NotNull CompoundTag tag, ServerLevel level) throws DoNotAddException {
        this.chunkPos = new ChunkPos(tag.getLong("l"));
    }

    @Override
    public ResourceLocation getTypeId() {
        return LoaderTypeKeys.PHANTOM_LOADER;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PhantomChunkLoader that = (PhantomChunkLoader)o;
        return Objects.equals(this.chunkPos, that.chunkPos);
    }

    public int hashCode() {
        return Objects.hash(this.chunkPos);
    }

    @Override
    @NotNull
    public ChunkPos getChunkPos() {
        return this.chunkPos;
    }
}

