/*
 * Decompiled with CFR 0.152.
 */
package com.vicious.persist.io.parser;

public enum AssumedType {
    UNKNOWN{

        @Override
        public AssumedType append(char c) {
            if (c == '\"') {
                return STRING;
            }
            if (c == '\'') {
                return CHAR;
            }
            if (Character.isDigit(c) || c == '-') {
                return INTEGER;
            }
            if (c == '.') {
                return DECIMAL;
            }
            if (BOOLEAN.append(c) == BOOLEAN) {
                return BOOLEAN;
            }
            return STRING;
        }
    }
    ,
    INTEGER{

        @Override
        public AssumedType append(char c) {
            if (Character.isDigit(c)) {
                return this;
            }
            if (c == '.') {
                return DECIMAL;
            }
            return STRING;
        }

        @Override
        public Class<?> getType() {
            return Long.TYPE;
        }
    }
    ,
    DECIMAL{

        @Override
        public AssumedType append(char c) {
            if (Character.isDigit(c) || c == '.' || c == 'E') {
                return this;
            }
            return STRING;
        }

        @Override
        public Class<?> getType() {
            return Double.TYPE;
        }
    }
    ,
    BOOLEAN{
        final String booleanChars = "TtRrUuEeFfAaLlSs";

        @Override
        public AssumedType append(char c) {
            if ("TtRrUuEeFfAaLlSs".indexOf(c) >= 0) {
                return this;
            }
            return STRING;
        }

        @Override
        public Class<?> getType() {
            return Boolean.TYPE;
        }
    }
    ,
    CHAR{

        @Override
        public AssumedType append(char c) {
            return CHAR;
        }

        @Override
        public Class<?> getType() {
            return Character.TYPE;
        }
    }
    ,
    STRING{

        @Override
        public AssumedType append(char c) {
            return STRING;
        }
    };


    public Class<?> getType() {
        return String.class;
    }

    public abstract AssumedType append(char var1);
}

