/*
 * Decompiled with CFR 0.152.
 */
package com.drathonix.loadmychunks.common.util;

import com.google.gson.JsonObject;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2172;
import net.minecraft.class_2314;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_7157;

public class BoolArgument
implements ArgumentType<Boolean> {
    private static final Dynamic2CommandExceptionType INVALID_BOOL = new Dynamic2CommandExceptionType((found, constants) -> class_2561.method_43469((String)"commands.loadmychunks.arguments.bool.invalid", (Object[])new Object[]{constants, found}));
    private static final List<String> examples = new ArrayList<String>();

    public static BoolArgument boolArgument() {
        return new BoolArgument();
    }

    public Boolean parse(StringReader reader) throws CommandSyntaxException {
        String name = reader.readUnquotedString();
        try {
            return Boolean.parseBoolean(name) || name.equalsIgnoreCase("ON");
        }
        catch (Throwable e) {
            throw INVALID_BOOL.createWithContext((ImmutableStringReader)reader, (Object)name, (Object)this.getExamples().toString());
        }
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return class_2172.method_9265(this.getExamples(), (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return examples;
    }

    static {
        examples.add("TRUE");
        examples.add("FALSE");
        examples.add("ON");
        examples.add("OFF");
    }

    public static class Info
    implements class_2314<BoolArgument, Template> {
        public void serializeToNetwork(Template template, class_2540 buffer) {
        }

        public Template deserializeFromNetwork(class_2540 buffer) {
            return new Template();
        }

        public void serializeToJson(Template template, JsonObject json) {
        }

        public Template unpack(BoolArgument argument) {
            return new Template();
        }

        public class Template
        implements class_2314.class_7217<BoolArgument> {
            Template() {
            }

            public BoolArgument instantiate(class_7157 p_223435_) {
                return new BoolArgument();
            }

            public class_2314<BoolArgument, ?> method_41728() {
                return Info.this;
            }
        }
    }
}

