/*
 * Decompiled with CFR 0.152.
 */
package com.vicious.persist.mappify.registry;

import com.vicious.persist.util.ClassMap;
import java.util.UUID;
import java.util.function.Function;

public class Stringify {
    private static final ClassMap<Converter<?>> converters = new ClassMap();

    private static byte clampedParseByte(String str) {
        return (byte)Math.min(Math.max(Long.parseLong(str), -128L), 127L);
    }

    private static short clampedParseShort(String str) {
        return (short)Math.min(Math.max(Long.parseLong(str), -32768L), 32767L);
    }

    private static int clampedParseInt(String str) {
        return (int)Math.min(Math.max(Long.parseLong(str), Integer.MIN_VALUE), Integer.MAX_VALUE);
    }

    private static <E, T extends E> void register(Function<String, T> stringToObject, Function<T, String> objectToString, Class<T> ... classes) {
        for (Class<T> aClass : classes) {
            converters.put(aClass, new Converter<T>(stringToObject, objectToString));
        }
    }

    public static <T> void register(Class<T> cls, Function<String, T> stringToObject, Function<T, String> objectToString) {
        converters.put(cls, new Converter<T>(stringToObject, objectToString));
    }

    public static <T> String stringify(T obj) {
        if (obj == null) {
            return "null";
        }
        Class<?> cls = obj.getClass();
        Converter converter = (Converter)converters.get(cls);
        if (converter == null) {
            if (obj instanceof Enum) {
                return "\"" + ((Enum)obj).name() + "\"";
            }
            throw new IllegalArgumentException("No toString converter registered for " + String.valueOf(cls));
        }
        return converter.objectToString.apply(obj);
    }

    public static <T> T objectify(Class<T> cls, String str) {
        if (str.equals("null")) {
            return null;
        }
        if (cls.isEnum()) {
            if (str.startsWith("\"") && str.endsWith("\"")) {
                str = str.substring(1, str.length() - 1);
            }
            return Enum.valueOf(cls, str);
        }
        Converter converter = (Converter)converters.get(cls);
        if (converter == null) {
            throw new IllegalArgumentException("No toObject converter registered for " + String.valueOf(cls));
        }
        return converter.stringToObject.apply(str);
    }

    public static boolean present(Class<?> cls) {
        return converters.containsKey(cls);
    }

    static {
        Stringify.register(Stringify::clampedParseByte, Object::toString, Byte.TYPE, Byte.class);
        Stringify.register(Stringify::clampedParseShort, Object::toString, Short.TYPE, Short.class);
        Stringify.register(Stringify::clampedParseInt, Object::toString, Integer.TYPE, Integer.class);
        Stringify.register(Long::parseLong, Object::toString, Long.TYPE, Long.class);
        Stringify.register(Float::parseFloat, Object::toString, Float.TYPE, Float.class);
        Stringify.register(Double::parseDouble, Object::toString, Double.TYPE, Double.class);
        Stringify.register(Boolean::parseBoolean, Object::toString, Boolean.TYPE, Boolean.class);
        Stringify.register((String str) -> Character.valueOf(str.charAt(0)), Object::toString, Character.TYPE, Character.class);
        Stringify.register(String.class, (String str) -> str, (T str) -> str);
        Stringify.register(UUID.class, UUID::fromString, UUID::toString);
        Stringify.register(Class.class, (String str) -> {
            try {
                return Class.forName(str);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }, Class::getName);
    }

    private static class Converter<T> {
        Function<String, T> stringToObject;
        Function<T, String> objectToString;

        public Converter(Function<String, T> stringToObject, Function<T, String> objectToString) {
            this.stringToObject = stringToObject;
            this.objectToString = objectToString;
        }
    }
}

