/*
 * Decompiled with CFR 0.152.
 */
package com.drathonix.loadmychunks.common.block;

import com.drathonix.loadmychunks.common.block.blockentity.BlockEntityChunkLoader;
import com.drathonix.loadmychunks.common.config.LMCConfig;
import com.drathonix.loadmychunks.common.registry.LMCContent;
import com.drathonix.loadmychunks.common.registry.custom.LoadStateRegistry;
import com.drathonix.loadmychunks.common.system.ChunkDataManager;
import com.drathonix.loadmychunks.common.system.loaders.IHasChunkloader;
import com.drathonix.loadmychunks.common.util.Message;
import com.mojang.serialization.MapCodec;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockChunkLoader
extends BaseEntityBlock {
    public static final MapCodec<BlockChunkLoader> CODEC = BlockChunkLoader.simpleCodec(BlockChunkLoader::new);

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public BlockChunkLoader(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void setPlacedBy(Level level, BlockPos blockPos, BlockState blockState, @Nullable LivingEntity livingEntity, ItemStack itemStack) {
        BlockEntity entity;
        super.setPlacedBy(level, blockPos, blockState, livingEntity, itemStack);
        if (livingEntity instanceof ServerPlayer && (entity = level.getBlockEntity(blockPos)) instanceof BlockEntityChunkLoader) {
            ((BlockEntityChunkLoader)entity).setOwner(livingEntity.getUUID());
            if (ChunkDataManager.hasExceededOwnershipCap(livingEntity.getUUID())) {
                Message.send((ServerPlayer)livingEntity, (Component)Message.styled(Message.translatable("loadmychunks.message.too_many_loaded_chunks", LMCConfig.limitSettings.limit, ChunkDataManager.getCountLoadedChunksOf(livingEntity.getUUID())), ChatFormatting.RED, true, true));
            }
        }
    }

    public void onRemove(BlockState blockState, Level level, BlockPos blockPos, BlockState blockState2, boolean isMoving) {
        BlockEntityChunkLoader blockEntity = (BlockEntityChunkLoader)level.getBlockEntity(blockPos);
        IHasChunkloader.ifPresent(blockEntity, loader -> {
            int j;
            NonNullList out = NonNullList.create();
            for (int k = loader.getExtensionRange(); k > 0; k -= j) {
                j = Math.min(64, k);
                out.add((Object)new ItemStack((ItemLike)LMCContent.itemExtension.get(), j));
            }
            if (loader.getDefaultState() == LoadStateRegistry.ENTITY_TICKING) {
                out.add((Object)new ItemStack((ItemLike)LMCContent.itemLifeforceBroadcaster.get()));
            }
            Containers.dropContents((Level)level, (BlockPos)blockPos, (NonNullList)out);
        });
        super.onRemove(blockState, level, blockPos, blockState2, isMoving);
    }

    @NotNull
    public RenderShape getRenderShape(BlockState blockState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new BlockEntityChunkLoader(blockPos, blockState);
    }
}

