/*
 * Decompiled with CFR 0.152.
 */
package com.drathonix.loadmychunks.common.integ.cct.turtle;

import com.mojang.math.Transformation;
import dan200.computercraft.api.client.TransformedModel;
import dan200.computercraft.api.client.turtle.TurtleUpgradeModeller;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.impl.client.ClientPlatformHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class UpgradeModeller<T extends ITurtleUpgrade>
implements TurtleUpgradeModeller<T> {
    public static final Transformation leftTransform = UpgradeModeller.getMatrixFor(-0.45f);
    public static final Transformation rightTransform = UpgradeModeller.getMatrixFor(-0.05f);

    private static Transformation getMatrixFor(float offset) {
        return new Transformation(new Vector3f(0.5f + offset, 0.25f, 0.225f), null, new Vector3f(0.5f, 0.5f, 0.5f), null);
    }

    public TransformedModel getModel(T t, @Nullable ITurtleAccess turtle, TurtleSide side, CompoundTag compoundTag) {
        ItemStack stack = t.getUpgradeItem(compoundTag);
        BakedModel model = Minecraft.getInstance().getItemRenderer().getItemModelShaper().getItemModel(stack);
        if (stack.hasFoil()) {
            model = ClientPlatformHelper.get().createdFoiledModel(model);
        }
        TransformedModel out = new TransformedModel(model, side == TurtleSide.LEFT ? leftTransform : rightTransform);
        return out;
    }
}

