/*
 * Decompiled with CFR 0.152.
 */
package com.drathonix.loadmychunks.common.mixin;

import com.drathonix.loadmychunks.common.bridge.IChunkMapMixin;
import com.drathonix.loadmychunks.common.bridge.IDistanceManagerMixin;
import com.mojang.datafixers.DataFixer;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import java.lang.reflect.Field;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.DistanceManager;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.entity.ChunkStatusUpdateListener;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.LevelStorageSource;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ChunkMap.class})
public abstract class MixinChunkMap
implements IChunkMapMixin {
    @Shadow
    @Final
    private Long2ObjectLinkedOpenHashMap<ChunkHolder> updatingChunkMap;
    @Unique
    private IDistanceManagerMixin lmc$distanceManager;
    @Shadow
    @Final
    private ServerLevel level;

    @Shadow
    abstract boolean anyPlayerCloseEnoughForSpawning(ChunkPos var1);

    @Inject(method={"<init>(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/level/storage/LevelStorageSource$LevelStorageAccess;Lcom/mojang/datafixers/DataFixer;Lnet/minecraft/world/level/levelgen/structure/templatesystem/StructureTemplateManager;Ljava/util/concurrent/Executor;Lnet/minecraft/util/thread/BlockableEventLoop;Lnet/minecraft/world/level/chunk/LightChunkGetter;Lnet/minecraft/world/level/chunk/ChunkGenerator;Lnet/minecraft/server/level/progress/ChunkProgressListener;Lnet/minecraft/world/level/entity/ChunkStatusUpdateListener;Ljava/util/function/Supplier;IZ)V"}, at={@At(value="RETURN")})
    public void captureDistMan(ServerLevel serverLevel, LevelStorageSource.LevelStorageAccess levelStorageAccess, DataFixer dataFixer, StructureTemplateManager structureTemplateManager, Executor executor, BlockableEventLoop blockableEventLoop, LightChunkGetter lightChunkGetter, ChunkGenerator chunkGenerator, ChunkProgressListener chunkProgressListener, ChunkStatusUpdateListener chunkStatusUpdateListener, Supplier supplier, int i, boolean bl, CallbackInfo ci) {
        for (Field declaredField : this.getClass().getDeclaredFields()) {
            if (!IDistanceManagerMixin.class.isAssignableFrom(declaredField.getType())) continue;
            try {
                declaredField.setAccessible(true);
                this.lmc$distanceManager = (IDistanceManagerMixin)declaredField.get(this);
                return;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public Long2ObjectLinkedOpenHashMap<ChunkHolder> lmc$getUpdatingChunkMap() {
        return this.updatingChunkMap;
    }

    @Override
    public boolean lmc$playerDistCheck(ChunkPos pos) {
        return this.anyPlayerCloseEnoughForSpawning(pos);
    }

    @Unique
    private boolean lmc$playerIsCloseEnoughForSpawning(ServerPlayer p_183752_, ChunkPos p_183753_) {
        if (p_183752_.isSpectator()) {
            return false;
        }
        double d0 = MixinChunkMap.lmc$euclideanDistanceSquared(p_183753_, (Entity)p_183752_);
        return d0 < 16384.0;
    }

    @Unique
    private static double lmc$euclideanDistanceSquared(ChunkPos p_140227_, Entity p_140228_) {
        double d0 = SectionPos.sectionToBlockCoord((int)p_140227_.x) + 8;
        double d1 = SectionPos.sectionToBlockCoord((int)p_140227_.z) + 8;
        double d2 = d0 - p_140228_.getX();
        double d3 = d1 - p_140228_.getZ();
        return d2 * d2 + d3 * d3;
    }

    @Override
    public boolean lmc$inEntityTickingRange(long l) {
        return this.lmc$distanceManager.lmc$inEntityTickingRange(l);
    }

    @Override
    public DistanceManager lmc$getDistanceManager() {
        return (DistanceManager)this.lmc$distanceManager;
    }
}

