/*
 * Decompiled with CFR 0.152.
 */
package com.drathonix.loadmychunks.common.mixin;

import com.drathonix.loadmychunks.common.bridge.IDestroyable;
import com.drathonix.loadmychunks.common.bridge.ILevelChunkMixin;
import com.drathonix.loadmychunks.common.bridge.ILevelMixin;
import com.drathonix.loadmychunks.common.mixin.MixinChunkAccess;
import com.drathonix.loadmychunks.common.system.ChunkDataManager;
import com.drathonix.loadmychunks.common.system.ChunkDataModule;
import com.drathonix.loadmychunks.common.system.control.ILoadState;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.UpgradeData;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.ticks.LevelChunkTicks;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={LevelChunk.class})
public abstract class MixinLevelChunk
extends MixinChunkAccess
implements ILevelChunkMixin {
    @Shadow
    @Final
    Level level;
    @Unique
    private final List<TickingBlockEntity> loadMyChunks$queuedTickers = new ArrayList<TickingBlockEntity>();
    @Unique
    private final List<TickingBlockEntity> loadMyChunks$tickers = new ArrayList<TickingBlockEntity>();
    @Unique
    private ChunkDataModule loadMyChunks$loadDataModule;

    @Override
    public ChunkDataModule loadMyChunks$getDataModule() {
        return this.loadMyChunks$loadDataModule;
    }

    public ChunkDataModule loadMyChunks$getAndCache() {
        if (this.loadMyChunks$loadDataModule == null) {
            this.loadMyChunks$loadDataModule = ChunkDataManager.getOrCreateChunkData((ServerLevel)this.level, this.loadMyChunks$posAsLong());
        }
        return this.loadMyChunks$loadDataModule;
    }

    @Override
    public long loadMyChunks$posAsLong() {
        return this.chunkPos.toLong();
    }

    @Override
    @Unique
    public void loadMyChunks$tickEntities(ProfilerFiller profilerfiller) {
        if (this.level instanceof ServerLevel) {
            this.loadMyChunks$loadDataModule.tickEntities((ServerLevel)this.level, profilerfiller);
        }
    }

    @Shadow
    @Nullable
    public abstract BlockEntity getBlockEntity(BlockPos var1);

    @Shadow
    public abstract Level getLevel();

    @Inject(method={"<init>(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/level/ChunkPos;Lnet/minecraft/world/level/chunk/UpgradeData;Lnet/minecraft/world/ticks/LevelChunkTicks;Lnet/minecraft/world/ticks/LevelChunkTicks;J[Lnet/minecraft/world/level/chunk/LevelChunkSection;Lnet/minecraft/world/level/chunk/LevelChunk$PostLoadProcessor;Lnet/minecraft/world/level/levelgen/blending/BlendingData;)V"}, at={@At(value="RETURN")})
    public void setup(Level arg, ChunkPos arg2, UpgradeData arg3, LevelChunkTicks arg4, LevelChunkTicks arg5, long l, LevelChunkSection[] args, LevelChunk.PostLoadProcessor arg6, BlendingData arg7, CallbackInfo ci) {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            this.loadMyChunks$getAndCache();
        }
    }

    @Override
    public void loadMyChunks$tick() {
        TickingBlockEntity tickingblockentity;
        if (this.level instanceof ServerLevel) {
            this.loadMyChunks$loadDataModule.preTick((ServerLevel)this.level);
        }
        boolean applyTimings = this.loadMyChunks$loadDataModule.shouldApplyTimings() && !this.level.isClientSide;
        boolean useTimings = applyTimings || !this.level.isClientSide && this.loadMyChunks$loadDataModule.shouldUseTimings();
        Iterator<TickingBlockEntity> iterator = this.loadMyChunks$queuedTickers.iterator();
        while (iterator.hasNext()) {
            tickingblockentity = iterator.next();
            this.loadMyChunks$tickers.add(tickingblockentity);
            iterator.remove();
        }
        if (useTimings) {
            this.loadMyChunks$loadDataModule.getTickTimer().startBlockEntities();
        }
        iterator = this.loadMyChunks$tickers.iterator();
        while (iterator.hasNext()) {
            tickingblockentity = iterator.next();
            if (tickingblockentity.isRemoved()) {
                ((ILevelMixin)this.level).loadMyChunks$removeTicker(tickingblockentity);
                iterator.remove();
                continue;
            }
            tickingblockentity.tick();
        }
        if (useTimings) {
            this.loadMyChunks$loadDataModule.getTickTimer().endBlockEntities();
            this.loadMyChunks$loadDataModule.inform();
            if (applyTimings && this.loadMyChunks$loadDataModule.isOverticked()) {
                ILoadState prev = this.loadMyChunks$loadDataModule.getLoadState();
                this.loadMyChunks$loadDataModule.startShutoff();
                ChunkDataManager.markShutDown((ServerLevel)this.level, this.chunkPos, prev);
            }
        }
    }

    @Inject(method={"getBlockEntity(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/chunk/LevelChunk$EntityCreationType;)Lnet/minecraft/world/level/block/entity/BlockEntity;"}, at={@At(value="INVOKE", target="Ljava/util/Map;remove(Ljava/lang/Object;)Ljava/lang/Object;", ordinal=0)}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/BlockEntity;isRemoved()Z"))}, locals=LocalCapture.CAPTURE_FAILHARD)
    public void properlyDestroyTileEntities1(BlockPos blockPos, LevelChunk.EntityCreationType entityCreationType, CallbackInfoReturnable<BlockEntity> cir, BlockEntity blockEntity) {
        if (!this.level.isClientSide && blockEntity instanceof IDestroyable) {
            IDestroyable destroyable = (IDestroyable)blockEntity;
            destroyable.loadMyChunks$destroy();
        }
    }

    @Redirect(method={"removeBlockEntity(Lnet/minecraft/core/BlockPos;)V"}, at=@At(value="INVOKE", target="Ljava/util/Map;remove(Ljava/lang/Object;)Ljava/lang/Object;", ordinal=0))
    public Object properlyDestroyTileEntities2(Map<?, ?> instance, Object o) {
        Object rem = instance.remove(o);
        if (rem instanceof IDestroyable) {
            IDestroyable destroyable = (IDestroyable)rem;
            if (!this.level.isClientSide()) {
                destroyable.loadMyChunks$destroy();
            }
        }
        return rem;
    }

    @Inject(method={"clearAllBlockEntities()V"}, at={@At(value="RETURN")})
    public void clearQueues(CallbackInfo ci) {
        this.loadMyChunks$queuedTickers.clear();
        this.loadMyChunks$tickers.clear();
    }

    @Redirect(method={"updateBlockEntityTicker(Lnet/minecraft/world/level/block/entity/BlockEntity;)V"}, at=@At(value="INVOKE", target="Ljava/util/Map;compute(Ljava/lang/Object;Ljava/util/function/BiFunction;)Ljava/lang/Object;"))
    public <K, V> Object addToQueue(Map<K, V> instance, K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        if (!instance.containsKey(key)) {
            V current = instance.get(key);
            TickingBlockEntity result = (TickingBlockEntity)instance.compute(key, remappingFunction);
            if (result != null) {
                this.loadMyChunks$queuedTickers.add(result);
            } else if (current != null) {
                this.loadMyChunks$tickers.remove(result);
                this.loadMyChunks$queuedTickers.remove(result);
            }
            return result;
        }
        return remappingFunction.apply(key, instance.get(key));
    }
}

