/*
 * Decompiled with CFR 0.152.
 */
package com.drathonix.loadmychunks.common.mixin.cct;

import com.drathonix.loadmychunks.common.integ.cct.bridge.ITurtleBrainMixin;
import com.drathonix.loadmychunks.common.integ.cct.turtle.TurtleChunkLoader;
import com.drathonix.loadmychunks.common.system.ChunkDataManager;
import com.drathonix.loadmychunks.common.system.ChunkDataModule;
import com.drathonix.loadmychunks.common.util.MultiversioningHelper;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.turtle.blocks.TurtleBlockEntity;
import dan200.computercraft.shared.turtle.core.TurtleBrain;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={TurtleBrain.class}, remap=false)
public abstract class MixinTurtleBrain
implements ITurtleBrainMixin {
    @Unique
    public AtomicReference<TurtleChunkLoader> lmc$chunkLoader = new AtomicReference();
    @Unique
    @Nullable
    public ChunkDataModule lmc$cdm;

    @Shadow
    public abstract IPeripheral getPeripheral(TurtleSide var1);

    @Shadow
    public abstract Level getLevel();

    @Shadow
    @NotNull
    public abstract BlockPos getPosition();

    @Inject(method={"updatePeripherals(Ldan200/computercraft/shared/computer/core/ServerComputer;)V"}, at={@At(value="TAIL")})
    public void lmc$checkShouldUnload(ServerComputer serverComputer, CallbackInfo ci) {
        if (this.lmc$shouldChunkLoad()) {
            this.lmc$addToCDM();
        } else {
            this.lmc$removeChunkLoader();
        }
    }

    @Inject(method={"setupComputer(Ldan200/computercraft/shared/computer/core/ServerComputer;)V"}, at={@At(value="HEAD")})
    public void setup(ServerComputer computer, CallbackInfo ci) {
        if (this.lmc$shouldChunkLoad()) {
            this.lmc$addToCDM();
        }
    }

    @Override
    public boolean lmc$preMove(ServerLevel sl, BlockPos newPosition) {
        boolean stable = this.lmc$shouldChunkLoad();
        if (stable) {
            ChunkDataManager.computeChunkLoaderIfAbsent(sl, newPosition, TurtleChunkLoader.class, loader -> loader.getPosition().equals((Object)newPosition), () -> this.lmc$chunkLoader.get().move(newPosition));
            return ChunkDataManager.getOrCreateChunkData(sl, newPosition).getLoadState().shouldLoad();
        }
        return false;
    }

    @Inject(method={"setOwner(Ldan200/computercraft/shared/turtle/blocks/TurtleBlockEntity;)V"}, at={@At(value="RETURN")})
    public void lmc$postMove(TurtleBlockEntity owner, CallbackInfo ci) {
        MultiversioningHelper.serverLevel((BlockEntity)owner, sl -> {
            BlockPos newPosition = this.getPosition();
            this.lmc$chunkLoader.set(ChunkDataManager.computeChunkLoaderIfAbsent(sl, newPosition, TurtleChunkLoader.class, this.lmc$shouldChunkLoad(), loader -> loader.getPosition().equals((Object)newPosition), () -> new TurtleChunkLoader(newPosition, this)));
            this.lmc$chunkLoader.get().setTurtle(this);
            this.lmc$cdm = ChunkDataManager.getOrCreateChunkData(sl, newPosition);
            ChunkDataManager.setDirty(sl);
        });
    }

    @Override
    @NotNull
    public TurtleChunkLoader lmc$getChunkLoader() {
        if (this.lmc$chunkLoader.get() == null) {
            MultiversioningHelper.serverLevel(this.getLevel(), sl -> {
                BlockPos pos = this.getPosition();
                this.lmc$chunkLoader.set(ChunkDataManager.computeChunkLoaderIfAbsent(sl, pos, TurtleChunkLoader.class, this.lmc$shouldChunkLoad(), cl -> cl.getPosition().equals((Object)pos), () -> new TurtleChunkLoader(pos, this)));
                this.lmc$chunkLoader.get().setTurtle(this);
            });
        }
        return this.lmc$chunkLoader.get();
    }

    @Override
    @NotNull
    public ChunkDataModule lmc$getChunkDataModule() {
        if (this.lmc$cdm == null) {
            MultiversioningHelper.serverLevel(this.getLevel(), sl -> {
                this.lmc$cdm = ChunkDataManager.getOrCreateChunkData(sl, this.getPosition());
            });
        }
        return this.lmc$cdm;
    }
}

