/*
 * Decompiled with CFR 0.152.
 */
package com.drathonix.loadmychunks.common.registry.custom;

import com.drathonix.loadmychunks.common.system.control.ILoadState;
import com.drathonix.loadmychunks.common.system.control.LoadStateEnum;
import com.drathonix.loadmychunks.common.system.control.LoaderPower;
import com.drathonix.loadmychunks.common.util.ModResource;
import com.mojang.serialization.Lifecycle;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class LoadStateRegistry
extends MappedRegistry<ILoadState> {
    private static final List<ILoadState> statesByIndex = new ArrayList<ILoadState>();
    public static final ResourceKey<Registry<ILoadState>> KEY = ResourceKey.createRegistryKey((ResourceLocation)ModResource.of("loader_state"));
    public static final LoadStateRegistry INSTANCE = new LoadStateRegistry();
    public static final ILoadState DISABLED = LoadStateEnum.DISABLED;
    public static final ILoadState TICKING = LoadStateEnum.TICKING;
    public static final ILoadState ENTITY_TICKING;
    public static final ILoadState ENTITY_TICKING_PERMANENT;
    public static final ILoadState OVERTICKED;
    public static final ILoadState PERMANENT;
    public static final ILoadState PERMANENTLY_DISABLED;

    private LoadStateRegistry() {
        super(KEY, Lifecycle.stable(), true);
    }

    private static ILoadState register(ResourceLocation id, ILoadState type) {
        INSTANCE.register(ResourceKey.create(KEY, (ResourceLocation)id), type, Lifecycle.stable());
        return type;
    }

    public static ILoadState registerLoadState(ResourceLocation key, Function<Integer, ILoadState> stateFactory) {
        return LoadStateRegistry.registerLoadState(key, stateFactory.apply(LoadStateRegistry.getNextOpenId()));
    }

    private static ILoadState registerLoadState(ResourceLocation key, ILoadState state) {
        statesByIndex.add(LoadStateRegistry.register(key, state));
        return state;
    }

    private static int getNextOpenId() {
        return statesByIndex.size();
    }

    public static ILoadState fromCompound(@NotNull String key, @NotNull CompoundTag tag, @NotNull ILoadState defaultState) {
        if (tag.contains(key, 3)) {
            int k = tag.getInt(key);
            if (statesByIndex.size() < k || k < 0) {
                return defaultState;
            }
            return statesByIndex.get(k);
        }
        if (tag.contains(key, 8)) {
            Optional<ResourceLocation> k = Optional.ofNullable(ModResource.parse(tag.getString(key)));
            return k.map(l -> INSTANCE.getOptional((ResourceLocation)l).orElse(defaultState)).orElse(defaultState);
        }
        return defaultState;
    }

    static {
        OVERTICKED = LoadStateEnum.OVERTICKED;
        PERMANENT = LoadStateEnum.PERMANENT;
        PERMANENTLY_DISABLED = LoadStateEnum.PERMANENTLY_DISABLED;
        for (LoadStateEnum value : LoadStateEnum.values()) {
            LoadStateRegistry.registerLoadState(value.getResourceLocation(), value);
        }
        ENTITY_TICKING = LoadStateRegistry.registerLoadState(ModResource.of("entity_ticking"), (Integer id) -> new ILoadState((Integer)id){
            private final Holder.Reference<ILoadState> holder = INSTANCE.createIntrusiveHolder(this);
            final /* synthetic */ Integer val$id;
            {
                this.val$id = n;
            }

            @Override
            public Holder.Reference<ILoadState> getIntrusiveHolder() {
                return this.holder;
            }

            @Override
            public LoaderPower blockEntityTickingPower() {
                return LoaderPower.FORCED_MANAGED;
            }

            @Override
            public LoaderPower entityForcingPower() {
                return LoaderPower.FORCED_MANAGED;
            }

            @Override
            public int id() {
                return this.val$id;
            }
        });
        ENTITY_TICKING_PERMANENT = LoadStateRegistry.registerLoadState(ModResource.of("entity_ticking_permanent"), (Integer id) -> new ILoadState((Integer)id){
            private final Holder.Reference<ILoadState> holder = INSTANCE.createIntrusiveHolder(this);
            final /* synthetic */ Integer val$id;
            {
                this.val$id = n;
            }

            @Override
            public Holder.Reference<ILoadState> getIntrusiveHolder() {
                return this.holder;
            }

            @Override
            public LoaderPower blockEntityTickingPower() {
                return LoaderPower.FORCED;
            }

            @Override
            public LoaderPower entityForcingPower() {
                return LoaderPower.FORCED;
            }

            @Override
            public int id() {
                return this.val$id;
            }
        });
    }
}

