/*
 * Decompiled with CFR 0.152.
 */
package com.drathonix.loadmychunks.common.system.control;

import com.drathonix.loadmychunks.common.LoadMyChunks;
import com.drathonix.loadmychunks.common.registry.custom.LoadStateRegistry;
import com.drathonix.loadmychunks.common.system.control.ChunkForcer;
import com.drathonix.loadmychunks.common.system.control.LoaderPower;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ILoadState {
    public LoaderPower blockEntityTickingPower();

    public LoaderPower entityForcingPower();

    public int id();

    default public boolean overrides(ILoadState state) {
        return this.blockEntityTickingPower().ordinal() >= state.blockEntityTickingPower().ordinal() && this.entityForcingPower().ordinal() >= state.entityForcingPower().ordinal();
    }

    default public boolean shouldLoad() {
        return this.blockEntityTickingPower() == LoaderPower.FORCED_MANAGED || this.blockEntityTickingPower() == LoaderPower.FORCED;
    }

    default public boolean shouldForceEntities() {
        return this.entityForcingPower() == LoaderPower.FORCED_MANAGED || this.entityForcingPower() == LoaderPower.FORCED;
    }

    default public ILoadState getSuperiorLoadState(ILoadState loadState) {
        if (loadState.overrides(this)) {
            return loadState;
        }
        return this;
    }

    default public boolean permanent() {
        return this.blockEntityTickingPower() == LoaderPower.FORCED;
    }

    default public void apply(@NotNull ServerLevel level, long pos, @Nullable ILoadState previous) {
        this.apply(level, new ChunkPos(pos), previous);
    }

    default public void apply(@NotNull ServerLevel level, @NotNull BlockPos pos, @Nullable ILoadState previous) {
        this.apply(level, new ChunkPos(pos), previous);
    }

    default public void apply(@NotNull ServerLevel level, @NotNull ChunkPos pos, @Nullable ILoadState previous) {
        if (previous == null) {
            previous = LoadStateRegistry.DISABLED;
        }
        if (this.shouldLoad()) {
            if (!this.shouldForceEntities()) {
                LoadMyChunks.logger.log(LoadMyChunks.debugLevel, "Forceloading Chunk at: (" + pos.x + "," + pos.z + ") with level " + this.blockEntityTickingPower().name());
            } else {
                LoadMyChunks.logger.log(LoadMyChunks.debugLevel, "Entity Ticking Chunk at: (" + pos.x + "," + pos.z + ") with level " + this.entityForcingPower().name());
            }
            ChunkForcer.forceChunk(level, pos, this.shouldForceEntities());
        } else {
            LoadMyChunks.logger.log(LoadMyChunks.debugLevel, "Unforceloading Chunk at: (" + pos.x + "," + pos.z + ")");
            ChunkForcer.unforceChunk(level, pos, previous.shouldForceEntities());
        }
    }

    default public void putCompound(String key, CompoundTag tag) {
        tag.putInt(key, this.id());
    }

    public Holder.Reference<ILoadState> getIntrusiveHolder();
}

