/*
 * Decompiled with CFR 0.152.
 */
package com.drathonix.loadmychunks.common.system.loaders;

import com.drathonix.loadmychunks.common.config.LMCConfig;
import com.drathonix.loadmychunks.common.registry.LoaderTypeKeys;
import com.drathonix.loadmychunks.common.registry.custom.LoadStateRegistry;
import com.drathonix.loadmychunks.common.system.control.ILoadState;
import com.drathonix.loadmychunks.common.system.control.LoadStateEnum;
import com.drathonix.loadmychunks.common.system.loaders.DoNotAddException;
import com.drathonix.loadmychunks.common.system.loaders.IChunkLoader;
import com.drathonix.loadmychunks.common.system.loaders.IOwnable;
import com.drathonix.loadmychunks.common.system.loaders.extension.ExtensionChunkLoaders;
import com.drathonix.loadmychunks.common.system.loaders.extension.IExtensionChunkLoader;
import com.drathonix.loadmychunks.common.system.loaders.extension.PlacedExtensionChunkLoader;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlacedChunkLoader
implements IChunkLoader,
IOwnable {
    @Nullable
    protected ExtensionChunkLoaders extensions = null;
    protected int extensionRange = 0;
    @Nullable
    protected UUID owner;
    protected BlockPos position;
    protected ILoadState defaultState;
    protected ILoadState loadState = this.defaultState = (ILoadState)LMCConfig.placedChunkLoaderDefaultLevel.get();
    protected long activityEnd = -1L;

    public PlacedChunkLoader() {
    }

    public PlacedChunkLoader(BlockPos pos) {
        this.position = pos;
    }

    public PlacedChunkLoader(BlockPos pos, long activityEnd) {
        this.position = pos;
        this.activityEnd = activityEnd;
    }

    public PlacedChunkLoader(BlockPos pos, @Nullable UUID owner) {
        this.position = pos;
        this.owner = owner;
    }

    @Override
    @NotNull
    public CompoundTag save(CompoundTag tag) {
        if (this.hasOwner()) {
            tag.putUUID("owner", this.owner);
        }
        if (this.hasExtensions()) {
            tag.putInt("extensions", this.extensionRange);
        }
        tag.putLong("duration", this.activityEnd);
        this.loadState.putCompound("state", tag);
        this.defaultState.putCompound("default", tag);
        tag.putLong("pos", this.position.asLong());
        return tag;
    }

    @Override
    public void load(@NotNull CompoundTag tag, ServerLevel level) throws DoNotAddException {
        this.position = BlockPos.of((long)tag.getLong("pos"));
        if (tag.contains("owner")) {
            this.owner = tag.getUUID("owner");
        }
        if (tag.contains("duration")) {
            this.activityEnd = tag.getLong("duration");
        }
        this.defaultState = LoadStateRegistry.fromCompound("default", tag, LoadStateRegistry.TICKING);
        this.loadState = LoadStateRegistry.fromCompound("state", tag, this.defaultState);
        if (tag.contains("extensions")) {
            this.extend(level, tag.getInt("extensions"));
        }
    }

    @Override
    public void postLoad(ServerLevel level) throws DoNotAddException {
    }

    @Override
    public void setExtensionRange(int extensionRange) {
        this.extensionRange = extensionRange;
    }

    @Override
    public void setExtensionsMap(ExtensionChunkLoaders extensions) {
        this.extensions = extensions;
    }

    @Override
    public int getExtensionRange() {
        return this.extensionRange;
    }

    public PlacedExtensionChunkLoader createExtension(ChunkPos position) {
        return new PlacedExtensionChunkLoader(position, this);
    }

    @Override
    public <T extends IExtensionChunkLoader<?>> Class<T> getExtensionClass() {
        return PlacedExtensionChunkLoader.class;
    }

    @Override
    public boolean supportsExtensions() {
        return true;
    }

    @Override
    public boolean supportsEntityTicking() {
        return true;
    }

    @Override
    @Nullable
    public ExtensionChunkLoaders getExtensionChunkLoaders() {
        return this.extensions;
    }

    @Override
    public ExtensionChunkLoaders.Factory<?> getExtensionFactory() {
        return this::createExtension;
    }

    @Override
    @Nullable
    public UUID getOwner() {
        return this.owner;
    }

    protected boolean outOfTime() {
        return this.shouldConsumeItems() && this.activityEnd == -1L;
    }

    @Override
    public ILoadState getActiveState() {
        if (this.hasExceededChunkLimit() || this.outOfTime()) {
            return LoadStateEnum.DISABLED;
        }
        return this.loadState;
    }

    @Override
    public ILoadState getDefaultState() {
        return this.defaultState;
    }

    @Override
    public void setActiveState(ILoadState state) {
        this.loadState = state;
    }

    @Override
    public void setOwner(@NotNull UUID owner) {
        this.owner = owner;
    }

    @NotNull
    public BlockPos getPosition() {
        return this.position;
    }

    @Override
    public ResourceLocation getTypeId() {
        return LoaderTypeKeys.PLACED_LOADER;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlacedChunkLoader that = (PlacedChunkLoader)o;
        return Objects.equals(this.position, that.position);
    }

    public int hashCode() {
        return Objects.hash(this.position);
    }

    @Override
    @NotNull
    public ChunkPos getChunkPos() {
        return new ChunkPos(this.getPosition());
    }

    @Override
    public long getActivityEnd() {
        return this.activityEnd;
    }

    @Override
    public void setActivityEnd(long activityEnd) {
        this.activityEnd = activityEnd;
    }

    @Override
    @NotNull
    public BlockPos getItemSource() {
        return this.position.above();
    }

    @Override
    public ILoadState setDefaultState(ILoadState defaultState) {
        ILoadState prev = this.defaultState;
        this.defaultState = defaultState;
        if (this.loadState == LoadStateRegistry.TICKING) {
            this.loadState = defaultState;
        }
        return prev;
    }
}

