/*
 * Decompiled with CFR 0.152.
 */
package com.drathonix.loadmychunks.common.system.loaders.extension;

import com.drathonix.loadmychunks.common.system.loaders.IChunkLoader;
import com.drathonix.loadmychunks.common.system.loaders.PhantomChunkLoader;
import com.drathonix.loadmychunks.common.system.loaders.extension.IExtensionChunkLoader;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.world.level.ChunkPos;
import org.apache.commons.lang3.ArrayUtils;

public abstract class AtomicExtensionChunkLoader<T extends IChunkLoader>
extends PhantomChunkLoader
implements IExtensionChunkLoader<T> {
    protected AtomicReference<T>[] hosts;

    public AtomicExtensionChunkLoader() {
    }

    public AtomicExtensionChunkLoader(AtomicReference<T> host, ChunkPos loadedChunk) {
        super(loadedChunk);
        this.hosts = new AtomicReference[]{host};
    }

    @Override
    public void removeHost(Object loader) {
        this.hosts = (AtomicReference[])ArrayUtils.removeAllOccurrences((Object[])this.hosts, (Object)((AtomicReference)loader));
    }

    @Override
    public int getNumberOfHosts() {
        return this.hosts.length;
    }

    @Override
    public void addHost(Object host) {
        if (!ArrayUtils.contains((Object[])this.hosts, (Object)host)) {
            this.hosts = (AtomicReference[])ArrayUtils.add((Object[])this.hosts, (Object)((AtomicReference)host));
        }
    }

    @Override
    public T getHost(int i) {
        if (this.hosts.length <= i || i < 0) {
            return null;
        }
        return (T)((IChunkLoader)this.hosts[i].get());
    }
}

