/*
 * Decompiled with CFR 0.152.
 */
package com.drathonix.loadmychunks.common.util;

import com.mojang.brigadier.context.CommandContext;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Message {
    @NotNull
    public static MutableComponent translatable(@NotNull String key, Object ... args) {
        return Component.translatable((String)key, (Object[])args);
    }

    public static void send(@NotNull ServerPlayer player, @Nullable Component message) {
        if (message == null) {
            return;
        }
        player.sendSystemMessage(message);
    }

    public static void sendSuccess(@NotNull CommandContext<CommandSourceStack> ctx, @NotNull Component message) {
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> message, true);
    }

    @NotNull
    public static MutableComponent styled(@NotNull MutableComponent component, @NotNull ChatFormatting formatting, boolean bold, boolean underlined) {
        return component.setStyle(Style.EMPTY.withColor(formatting).withBold(Boolean.valueOf(bold)).withUnderlined(Boolean.valueOf(underlined)));
    }

    public static void sendSystem(@NotNull CommandContext<CommandSourceStack> ctx, @NotNull Component component) {
        ((CommandSourceStack)ctx.getSource()).sendSystemMessage(component);
    }

    @NotNull
    public static MutableComponent clickCommand(@NotNull MutableComponent component, @NotNull String command) {
        return component.setStyle(component.getStyle().withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, command)));
    }

    public static MutableComponent empty() {
        return Message.literal("");
    }

    public static MutableComponent literal(String text) {
        return Component.literal((String)text);
    }

    public static MutableComponent append(@NotNull MutableComponent m1, @NotNull Component m2) {
        return m1.append(m2);
    }

    public static MutableComponent append(MutableComponent m1, String str) {
        return m1.append(str);
    }
}

