/*
 * Decompiled with CFR 0.152.
 */
package com.drathonix.loadmychunks.common.util;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultiversioningHelper {
    @NotNull
    public static BlockBehaviour.Properties properties(String key) {
        return BlockBehaviour.Properties.of().requiresCorrectToolForDrops();
    }

    @NotNull
    public static BlockBehaviour.Properties properties(String key, float strength, float blastResistance) {
        return MultiversioningHelper.properties(key).strength(strength, blastResistance);
    }

    public static void serverLevel(BlockEntity blockEntity, Consumer<ServerLevel> cons) {
        MultiversioningHelper.serverLevel(blockEntity.getLevel(), cons);
    }

    public static void serverLevel(Level level, Consumer<ServerLevel> cons) {
        if (level instanceof ServerLevel) {
            cons.accept((ServerLevel)level);
        }
    }

    public static boolean isRemoved(Entity entity) {
        return entity.isRemoved();
    }

    public static ChunkPos chunkPosOf(Entity entity) {
        return entity.chunkPosition();
    }

    public static void serverLevel(Entity arg, Consumer<ServerLevel> cons) {
        Level l = arg.level();
        MultiversioningHelper.serverLevel(l, cons);
    }

    public static <T> Optional<T> enforceOptional(@Nullable Object obj) {
        if (obj instanceof Optional) {
            return (Optional)obj;
        }
        return Optional.ofNullable(obj);
    }

    @Nullable
    public static <T> T serverLevel(BlockEntity blockEntity, Function<ServerLevel, T> func) {
        Level l = blockEntity.getLevel();
        if (l instanceof ServerLevel) {
            return func.apply((ServerLevel)l);
        }
        return null;
    }

    public static <T> T enforceValue(Object obj) {
        if (obj instanceof Optional) {
            return MultiversioningHelper.enforceValue(((Optional)obj).get());
        }
        if (obj instanceof Holder.Reference) {
            return (T)((Holder.Reference)obj).value();
        }
        return (T)obj;
    }

    public static long chunkPosOfOld(Entity e) {
        return new ChunkPos(SectionPos.blockToSectionCoord((int)((int)e.xOld)), SectionPos.blockToSectionCoord((int)((int)e.zOld))).toLong();
    }
}

