/*
 * Decompiled with CFR 0.152.
 */
package com.drathonix.loadmychunks.neoforge.integ;

import com.drathonix.loadmychunks.common.block.blockentity.BlockEntityChunkLoader;
import com.drathonix.loadmychunks.common.block.blockentity.BlockEntityLagometer;
import com.drathonix.loadmychunks.common.integ.cct.CCTRegistryContent;
import com.drathonix.loadmychunks.common.integ.cct.peripheral.ChunkLoaderPeripheral;
import com.drathonix.loadmychunks.common.integ.cct.peripheral.LagometerPeripheral;
import com.drathonix.loadmychunks.common.integ.cct.turtle.TurtleChunkLoaderUpgrade;
import com.drathonix.loadmychunks.common.registry.FakeRegistrySupplier;
import com.drathonix.loadmychunks.common.registry.LMCContent;
import dan200.computercraft.api.peripheral.PeripheralCapability;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.upgrades.UpgradeSerialiser;
import dev.architectury.registry.registries.RegistrySupplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.registries.DeferredRegister;

public class CCTNeo {
    public static DeferredRegister<UpgradeSerialiser<? extends ITurtleUpgrade>> turtleUpgrades = DeferredRegister.create((ResourceKey)ITurtleUpgrade.serialiserRegistryKey(), (String)"loadmychunks");

    public static void register(IEventBus bus) {
        turtleUpgrades.register(bus);
        CCTRegistryContent.register();
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        Block[] blocks = new Block[LMCContent.chunkLoaderBlockMap.size()];
        int i = 0;
        for (RegistrySupplier<Block> chunkLoaderBlock : LMCContent.chunkLoaderBlockMap.values()) {
            blocks[i] = (Block)chunkLoaderBlock.get();
            ++i;
        }
        event.registerBlock(PeripheralCapability.get(), (level, pos, state, be, side) -> {
            if (be instanceof BlockEntityChunkLoader) {
                BlockEntityChunkLoader becl = (BlockEntityChunkLoader)be;
                return new ChunkLoaderPeripheral(becl.getBlockPos(), becl.getLevel(), becl.loadMyChunks$getChunkLoader());
            }
            return null;
        }, blocks);
        event.registerBlock(PeripheralCapability.get(), (level, pos, state, be, side) -> {
            if (be instanceof BlockEntityLagometer) {
                BlockEntityLagometer lagometer = (BlockEntityLagometer)be;
                return new LagometerPeripheral(lagometer.getBlockPos(), lagometer.getLevel());
            }
            return null;
        }, new Block[]{(Block)LMCContent.lagometerBlock.get()});
    }

    public static void init(IEventBus bus) {
        bus.addListener(CCTNeo::registerCapabilities);
        CCTNeo.register(bus);
    }

    public static void clientInit() {
        CCTRegistryContent.registerClient();
    }

    static {
        LMCContent.chunkLoaderBlockMap.forEach((color, supplier) -> {
            TurtleChunkLoaderUpgrade tclu = new TurtleChunkLoaderUpgrade((RegistrySupplier<Block>)supplier);
            FakeRegistrySupplier reg = new FakeRegistrySupplier(turtleUpgrades.register((String)(!color.isEmpty() ? color + "_" : "") + "chunk_loader", () -> UpgradeSerialiser.simple(key -> tclu)));
            CCTRegistryContent.registrySuppliers.add(reg);
        });
    }
}

