/*
 * Decompiled with CFR 0.152.
 */
package com.vicious.persist.mappify.reflect;

import com.vicious.persist.except.InvalidSavableElementException;
import com.vicious.persist.mappify.registry.Stringify;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

public interface TypeInfo {
    public static TypeInfo cast(final TypeInfo info, final Class<?> valueType) {
        return new TypeInfo(){

            @Override
            public Class<?> getType() {
                return valueType;
            }

            @Override
            public Class<?>[] getTyping() {
                return info.getTyping();
            }

            public String toString() {
                return "CastedInfo{" + String.valueOf(valueType) + ", " + Arrays.toString(info.getTyping()) + "}";
            }
        };
    }

    public Class<?> getType();

    public Class<?>[] getTyping();

    default public boolean isMap() {
        return Map.class.isAssignableFrom(this.getType());
    }

    default public boolean isCollection() {
        return Collection.class.isAssignableFrom(this.getType());
    }

    default public boolean isClass() {
        return Class.class.isAssignableFrom(this.getType());
    }

    default public boolean isPrimitive() {
        return this.getType().isPrimitive();
    }

    default public boolean canBeStringified() {
        return Stringify.present(this.getType());
    }

    default public boolean isArray() {
        return this.getType().isArray();
    }

    default public Class<?> getTyping(int index) {
        Class<?>[] typing = this.getTyping();
        if (typing.length <= index) {
            throw new InvalidSavableElementException("Typing is of length " + typing.length + " needs to be at least " + (index + 1));
        }
        return typing[index];
    }

    default public boolean isDataStructure() {
        return this.isMap() || this.isCollection() || this.isArray();
    }

    default public boolean isEnum() {
        return this.getType().isEnum();
    }
}

