/*
 * Decompiled with CFR 0.152.
 */
package com.drathonix.loadmychunks.common;

import com.drathonix.loadmychunks.common.bridge.IInformable;
import com.drathonix.loadmychunks.common.config.LMCConfig;
import com.drathonix.loadmychunks.common.registry.LMCContent;
import com.drathonix.loadmychunks.common.registry.custom.LoadStateRegistry;
import com.drathonix.loadmychunks.common.system.ChunkDataManager;
import com.drathonix.loadmychunks.common.system.ChunkDataModule;
import com.drathonix.loadmychunks.common.system.control.ILoadState;
import com.drathonix.loadmychunks.common.system.control.LoadStateEnum;
import com.drathonix.loadmychunks.common.util.Brigadier;
import com.drathonix.loadmychunks.common.util.Message;
import com.drathonix.loadmychunks.common.util.ModResource;
import com.drathonix.loadmychunks.common.util.MultiversioningHelper;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.vicious.persist.io.writer.wrapped.WrappedObject;
import com.vicious.persist.mappify.Mappifier;
import com.vicious.persist.mappify.registry.Stringify;
import com.vicious.persist.shortcuts.PersistShortcuts;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.networking.NetworkManager;
import java.util.List;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class LoadMyChunks {
    public static MinecraftServer server;
    public static final String MOD_ID = "loadmychunks";
    public static final Logger logger;
    public static Level debugLevel;
    public static boolean stopping;
    public static class_2960 LAG_READING_PACKET_ID;

    public static void init() {
        logger.info("Preparing to load your chunks...");
        LMCConfig.init();
        if (LMCConfig.zeroContent) {
            logger.info("Plugin mode is enabled! Item and block registration steps will be skipped");
        }
        if (LMCConfig.useDebugLogging) {
            logger.info("Changing to debug logging");
            debugLevel = Level.INFO;
            logger.info("Using Debug Logging");
        }
        CommandRegistrationEvent.EVENT.register(LoadMyChunks::registerCommands);
        LoadMyChunks.modMode(() -> {
            logger.info("Adding LMC content.");
            LMCContent.init();
            logger.info("Content added.");
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (class_2960)LAG_READING_PACKET_ID, (buf, context) -> {
            class_1657 plr = context.getPlayer();
            MultiversioningHelper.serverLevel((class_1297)plr, sl -> {
                ChunkDataModule cdm = ChunkDataManager.getOrCreateChunkData(sl, plr.method_24515());
                if (!LMCConfig.lagometerNeedsChunkOwnership || plr.method_5687(2) || cdm.containsOwnedLoader(plr.method_5667())) {
                    cdm.addRecipient((IInformable)plr);
                }
            });
        });
    }

    public static void serverStarted(MinecraftServer server) {
        stopping = false;
        LoadMyChunks.server = server;
    }

    public static void serverStopped(MinecraftServer server) {
        ChunkDataManager.clear();
    }

    public static boolean allowUsingDebugFeatures() {
        return false;
    }

    public static void registerCommands(CommandDispatcher<class_2168> dispatcher, class_7157 registry, class_2170.class_5364 selection) {
        dispatcher.register((LiteralArgumentBuilder)Brigadier.admin(Brigadier.literal(MOD_ID, root -> {
            root.add(Brigadier.executes(Brigadier.literal("forceload", forceLoad -> forceLoad.add(Brigadier.executes(Brigadier.bool("permanent", boolForceLoad -> boolForceLoad.add(Brigadier.executes(Brigadier.bool("entity_ticking", entityTickingForceLoad -> entityTickingForceLoad.add(Brigadier.executes(Brigadier.blockPos("pos", empty -> {}), ctx -> LoadMyChunks.handleCMDForceload((CommandContext<class_2168>)ctx, (Boolean)ctx.getArgument("permanent", Boolean.class), (Boolean)ctx.getArgument("entity_ticking", Boolean.class), Brigadier.getBlockPos((CommandContext<class_2168>)ctx, "pos"))))), ctx -> LoadMyChunks.handleCMDForceload((CommandContext<class_2168>)ctx, (Boolean)ctx.getArgument("permanent", Boolean.class), (Boolean)ctx.getArgument("entity_ticking", Boolean.class), null)))), ctx -> LoadMyChunks.handleCMDForceload((CommandContext<class_2168>)ctx, (Boolean)ctx.getArgument("permanent", Boolean.class), false, null)))), ctx -> LoadMyChunks.handleCMDForceload((CommandContext<class_2168>)ctx, true, false, null)));
            root.add(Brigadier.executes(Brigadier.literal("unforceload", unforceLoad -> unforceLoad.add(Brigadier.executes(Brigadier.bool("permanent", boolUnforceLoad -> boolUnforceLoad.add(Brigadier.executes(Brigadier.blockPos("pos", empty -> {}), ctx -> LoadMyChunks.handleCMDUnforceload((CommandContext<class_2168>)ctx, (Boolean)ctx.getArgument("permanent", Boolean.class), Brigadier.getBlockPos((CommandContext<class_2168>)ctx, "pos"))))), ctx -> LoadMyChunks.handleCMDUnforceload((CommandContext<class_2168>)ctx, (Boolean)ctx.getArgument("permanent", Boolean.class), null)))), ctx -> LoadMyChunks.handleCMDUnforceload((CommandContext<class_2168>)ctx, false, null)));
            root.add(Brigadier.literal("config", config -> config.add(Brigadier.string("path", pathcmd -> pathcmd.add(Brigadier.executes(Brigadier.string("value", empty -> {}), ctx -> {
                String path = (String)ctx.getArgument("path", String.class);
                String value = (String)ctx.getArgument("value", String.class);
                Object map = Mappifier.DEFAULT.mappify(LMCConfig.class).unwrap();
                String[] splitPath = path.split("/");
                Object o = map;
                for (int i = 0; i < splitPath.length - 1; ++i) {
                    String s = splitPath[i];
                    if (o instanceof WrappedObject) {
                        o = ((WrappedObject)o).object;
                    }
                    if (o instanceof Map) {
                        o = map.get(s);
                        if (o != null) continue;
                        Message.sendSystem((CommandContext<class_2168>)ctx, (class_2561)Message.translatable("commands.loadmychunks.config.bad_path_not_found", s));
                        return 0;
                    }
                    if (!(o instanceof List)) continue;
                    List list = (List)o;
                    try {
                        o = list.get(Stringify.objectify(Integer.class, value));
                        continue;
                    }
                    catch (Throwable e) {
                        Message.sendSystem((CommandContext<class_2168>)ctx, (class_2561)Message.translatable("commands.loadmychunks.config.invalid_integer", s));
                        return 0;
                    }
                }
                String key = splitPath[splitPath.length - 1];
                if (o instanceof Map) {
                    Map m = (Map)o;
                    m.put(key, value);
                }
                if (o instanceof List) {
                    int k;
                    List l = (List)o;
                    try {
                        k = Integer.parseInt(key);
                    }
                    catch (Throwable e) {
                        Message.sendSystem((CommandContext<class_2168>)ctx, (class_2561)Message.translatable("commands.loadmychunks.config.invalid_integer", key));
                        return 0;
                    }
                    l.set(k, value);
                }
                try {
                    Mappifier.DEFAULT.unmappify(LMCConfig.class, (Map<Object, Object>)map);
                    PersistShortcuts.saveAsFile(LMCConfig.class);
                }
                catch (Throwable e) {
                    Message.sendSystem((CommandContext<class_2168>)ctx, (class_2561)Message.translatable("commands.loadmychunks.config.invalid_value", value));
                    return 0;
                }
                Message.sendSystem((CommandContext<class_2168>)ctx, (class_2561)Message.translatable("commands.loadmychunks.config.value_set", path, value));
                LMCConfig.postReload();
                Message.sendSystem((CommandContext<class_2168>)ctx, (class_2561)Message.translatable("commands.loadmychunks.config.reload_complete", new Object[0]));
                return 1;
            }))))));
            root.add(Brigadier.literal("list", list -> {
                list.add(Brigadier.executes(Brigadier.literal("forced", empty -> {}), ctx -> {
                    class_3218 level = Brigadier.getLevel((CommandContext<class_2168>)ctx);
                    Message.sendSystem((CommandContext<class_2168>)ctx, (class_2561)Message.styled(Message.translatable("commands.loadmychunks.list.forceloaded.header", new Object[0]), class_124.field_1075, true, true));
                    ChunkDataManager.getManager(level).getChunkDataModules().stream().filter(cdm -> cdm.getLoadState().shouldLoad()).forEach(cdm -> {
                        class_1923 pos = cdm.getPosition();
                        class_2338 dest = Brigadier.centralized(pos, 255);
                        if (cdm.getLoadState().permanent()) {
                            if (cdm.getLoadState().shouldForceEntities()) {
                                Message.sendSystem((CommandContext<class_2168>)ctx, (class_2561)Message.clickCommand(Message.translatable("commands.loadmychunks.list.forceloaded.entry.permanent.entity_ticking", pos.field_9181, pos.field_9180), "/tp " + dest.method_10263() + " " + dest.method_10264() + " " + dest.method_10260()));
                            } else {
                                Message.sendSystem((CommandContext<class_2168>)ctx, (class_2561)Message.clickCommand(Message.translatable("commands.loadmychunks.list.forceloaded.entry.permanent", pos.field_9181, pos.field_9180), "/tp " + dest.method_10263() + " " + dest.method_10264() + " " + dest.method_10260()));
                            }
                        } else if (cdm.getLoadState().shouldForceEntities()) {
                            Message.sendSystem((CommandContext<class_2168>)ctx, (class_2561)Message.clickCommand(Message.translatable("commands.loadmychunks.list.forceloaded.entry.entity_ticking", pos.field_9181, pos.field_9180), "/tp " + dest.method_10263() + " " + dest.method_10264() + " " + dest.method_10260()));
                        } else {
                            Message.sendSystem((CommandContext<class_2168>)ctx, (class_2561)Message.clickCommand(Message.translatable("commands.loadmychunks.list.forceloaded.entry", pos.field_9181, pos.field_9180), "/tp " + dest.method_10263() + " " + dest.method_10264() + " " + dest.method_10260()));
                        }
                    });
                    return 0;
                }));
                list.add(Brigadier.executes(Brigadier.literal("overticked", empty -> {}), ctx -> {
                    class_3218 level = Brigadier.getLevel((CommandContext<class_2168>)ctx);
                    Message.sendSystem((CommandContext<class_2168>)ctx, (class_2561)Message.styled(Message.translatable("commands.loadmychunks.list.overticked.header", new Object[0]), class_124.field_1075, true, true));
                    ChunkDataManager.getManager(level).getChunkDataModules().stream().filter(cdm -> cdm.getLoadState() == LoadStateEnum.OVERTICKED || cdm.getLoadState() == LoadStateEnum.PERMANENTLY_DISABLED).forEach(cdm -> {
                        class_1923 pos = cdm.getPosition();
                        class_2338 dest = Brigadier.centralized(pos, 255);
                        if (cdm.getLoadState() == LoadStateEnum.PERMANENTLY_DISABLED) {
                            Message.sendSystem((CommandContext<class_2168>)ctx, (class_2561)Message.clickCommand(Message.translatable("commands.loadmychunks.list.forceloaded.entry.permanent", pos.field_9181, pos.field_9180), "/tp " + dest.method_10263() + " " + dest.method_10264() + " " + dest.method_10260()));
                        } else {
                            Message.sendSystem((CommandContext<class_2168>)ctx, (class_2561)Message.clickCommand(Message.translatable("commands.loadmychunks.list.forceloaded.entry", pos.field_9181, pos.field_9180), "/tp " + dest.method_10263() + " " + dest.method_10264() + " " + dest.method_10260()));
                        }
                    });
                    return 0;
                }));
            }));
            root.add(Brigadier.executes(Brigadier.literal("reload", empty -> {}), ctx -> {
                Message.sendSystem((CommandContext<class_2168>)ctx, (class_2561)Message.translatable("commands.loadmychunks.config.reload_started", new Object[0]));
                LMCConfig.reload();
                Message.sendSystem((CommandContext<class_2168>)ctx, (class_2561)Message.translatable("commands.loadmychunks.config.reload_complete", new Object[0]));
                return 1;
            }));
            root.add(Brigadier.executes(Brigadier.literal("awaken", awaken -> awaken.add(Brigadier.executes(Brigadier.blockPos("pos", empty -> {}), ctx -> LoadMyChunks.handleCMDAwaken((CommandContext<class_2168>)ctx, Brigadier.getBlockPos((CommandContext<class_2168>)ctx, "pos"))))), ctx -> LoadMyChunks.handleCMDAwaken((CommandContext<class_2168>)ctx, null)));
        })));
    }

    private static int handleCMDForceload(CommandContext<class_2168> ctx, boolean permanent, boolean entityTicking, @Nullable class_2338 bp) {
        bp = Brigadier.defaultedPos(ctx, bp);
        class_1923 pos = new class_1923(bp);
        class_3218 level = Brigadier.getLevel(ctx);
        ChunkDataModule cdm = ChunkDataManager.getOrCreateChunkData(level, pos);
        ILoadState prev = cdm.defaultLoadState;
        cdm.defaultLoadState = permanent ? (entityTicking ? LoadStateRegistry.ENTITY_TICKING_PERMANENT : LoadStateEnum.PERMANENT) : (entityTicking ? LoadStateRegistry.PERMANENT : LoadStateEnum.TICKING);
        cdm.clearCooldowns();
        cdm.update();
        cdm.getLoadState().apply(level, pos, prev);
        if (permanent) {
            Message.sendSystem(ctx, (class_2561)Message.translatable("loadmychunks.command.forceload.set.permanent", pos.field_9181, pos.field_9180));
        } else {
            Message.sendSystem(ctx, (class_2561)Message.translatable("loadmychunks.command.forceload.set", pos.field_9181, pos.field_9180));
        }
        return 1;
    }

    private static int handleCMDUnforceload(CommandContext<class_2168> ctx, boolean ban, @Nullable class_2338 bp) {
        bp = Brigadier.defaultedPos(ctx, bp);
        class_1923 pos = new class_1923(bp);
        class_3218 level = Brigadier.getLevel(ctx);
        ChunkDataModule cdm = ChunkDataManager.getOrCreateChunkData(level, pos);
        ILoadState prev = cdm.defaultLoadState;
        cdm.defaultLoadState = ban ? LoadStateEnum.PERMANENTLY_DISABLED : LoadStateEnum.DISABLED;
        cdm.update();
        cdm.getLoadState().apply(level, pos, prev);
        if (ban) {
            Message.sendSystem(ctx, (class_2561)Message.translatable("loadmychunks.command.forceload.unset.permanent", pos.field_9181, pos.field_9180));
        } else {
            Message.sendSystem(ctx, (class_2561)Message.translatable("loadmychunks.command.forceload.unset", pos.field_9181, pos.field_9180));
        }
        return 1;
    }

    private static int handleCMDAwaken(CommandContext<class_2168> ctx, @Nullable class_2338 bp) {
        bp = Brigadier.defaultedPos(ctx, bp);
        class_1923 pos = new class_1923(bp);
        class_3218 level = Brigadier.getLevel(ctx);
        ChunkDataModule cdm = ChunkDataManager.getOrCreateChunkData(level, pos);
        if (cdm.onCooldown()) {
            cdm.clearCooldowns();
            Message.sendSystem(ctx, (class_2561)Message.translatable("loadmychunks.command.awaken.success", pos.field_9181, pos.field_9180));
        } else {
            Message.sendSystem(ctx, (class_2561)Message.translatable("loadmychunks.command.awaken.redundant", pos.field_9181, pos.field_9180));
        }
        return 1;
    }

    public static void modMode(Runnable exec) {
        if (!LMCConfig.zeroContent) {
            exec.run();
        }
    }

    static {
        logger = LogManager.getLogger((String)MOD_ID);
        debugLevel = Level.DEBUG;
        stopping = false;
        LAG_READING_PACKET_ID = ModResource.of("lag");
    }
}

