/*
 * Decompiled with CFR 0.152.
 */
package com.drathonix.loadmychunks.common.block.blockentity;

import com.drathonix.loadmychunks.common.block.blockentity.BEBase;
import com.drathonix.loadmychunks.common.bridge.IDestroyable;
import com.drathonix.loadmychunks.common.registry.LMCContent;
import com.drathonix.loadmychunks.common.system.ChunkDataManager;
import com.drathonix.loadmychunks.common.system.loaders.IChunkLoader;
import com.drathonix.loadmychunks.common.system.loaders.IHasChunkloader;
import com.drathonix.loadmychunks.common.system.loaders.PlacedChunkLoader;
import com.drathonix.loadmychunks.common.util.MultiversioningHelper;
import java.util.UUID;
import net.minecraft.class_156;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;

public class BlockEntityChunkLoader
extends BEBase
implements IDestroyable,
IHasChunkloader {
    private PlacedChunkLoader chunkLoader;
    private UUID owner = class_156.field_25140;

    public BlockEntityChunkLoader(class_2338 blockPos, class_2680 blockState) {
        super((class_2591)LMCContent.chunkLoaderBlockEntity.get(), blockPos, blockState);
    }

    @Override
    public PlacedChunkLoader loadMyChunks$getChunkLoader() {
        return this.chunkLoader;
    }

    @Override
    protected void read(class_2487 tag) {
        super.read(tag);
        if (this.owner != null) {
            tag.method_25927("owner", this.owner);
        }
    }

    @Override
    protected void write(class_2487 tag) {
        super.write(tag);
        if (tag.method_10545("owner")) {
            this.setOwner(tag.method_25926("owner"));
        }
    }

    @Override
    public void loadMyChunks$destroy() {
        if (this.field_11863 instanceof class_3218) {
            ChunkDataManager.removeChunkLoader((class_3218)this.field_11863, this.method_11016(), (IChunkLoader)this.chunkLoader);
        }
    }

    @Override
    public void validate(class_1937 level) {
        MultiversioningHelper.serverLevel(level, sl -> {
            if (this.chunkLoader == null) {
                this.chunkLoader = ChunkDataManager.computeChunkLoaderIfAbsent(sl, this.method_11016(), PlacedChunkLoader.class, loader -> loader.getPosition().equals((Object)this.method_11016()), () -> new PlacedChunkLoader(this.method_11016(), this.owner));
            }
        });
    }

    public void setOwner(UUID uuid) {
        UUID prev = this.owner;
        this.owner = uuid == null ? class_156.field_25140 : uuid;
        MultiversioningHelper.serverLevel(this.field_11863, sl -> {
            if (this.chunkLoader != null) {
                this.chunkLoader.setOwner(uuid);
                ChunkDataManager.markChunkNotOwnedBy(sl, this.chunkLoader.getChunkPos().method_8324(), prev);
                ChunkDataManager.markChunkOwnedBy(sl, this.chunkLoader.getChunkPos().method_8324(), uuid);
            }
        });
    }
}

