/*
 * Decompiled with CFR 0.152.
 */
package com.drathonix.loadmychunks.common.integ.cct.peripheral;

import com.drathonix.loadmychunks.common.config.LMCConfig;
import com.drathonix.loadmychunks.common.system.ChunkDataModule;
import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.pocket.IPocketAccess;
import dan200.computercraft.api.turtle.ITurtleAccess;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractLagometerPeripheral
implements IPeripheral {
    @NotNull
    public abstract ChunkDataModule getChunkDataModule();

    public String getType() {
        return "lmc_lagometer";
    }

    @NotNull
    protected abstract class_3218 getLevel();

    @NotNull
    protected abstract class_2338 getPosition();

    @LuaFunction
    public final long getChunkLastTickDuration(ILuaContext context, IComputerAccess access, IArguments arguments) throws LuaException {
        this.checkPerm(access);
        return this.getChunkDataModule().getTickTimer().getDuration();
    }

    @LuaFunction
    public final long getChunkTickDurationLimit(ILuaContext context, IComputerAccess access, IArguments arguments) {
        return LMCConfig.msPerChunk;
    }

    @LuaFunction
    public final long getChunkLastTickRatio(ILuaContext context, IComputerAccess access, IArguments arguments) throws LuaException {
        this.checkPerm(access);
        return this.getChunkLastTickDuration(context, access, arguments) / LMCConfig.msPerChunk;
    }

    @LuaFunction
    public final long getChunkCooldownTime(ILuaContext context, IComputerAccess access, IArguments arguments) throws LuaException {
        this.checkPerm(access);
        return this.getChunkDataModule().getCooldownTime();
    }

    @LuaFunction
    public final boolean isChunkOnCooldown(ILuaContext context, IComputerAccess access, IArguments arguments) throws LuaException {
        this.checkPerm(access);
        return this.getChunkDataModule().onCooldown();
    }

    @LuaFunction
    public final boolean isChunkForced(ILuaContext context, IComputerAccess access, IArguments arguments) throws LuaException {
        this.checkPerm(access);
        return this.getChunkDataModule().getLoadState().shouldLoad();
    }

    public void checkPerm(IComputerAccess access) throws LuaException {
        if (!this.isLagometerPermitted(access)) {
            throw new LuaException("This feature is disabled for this computer type by the server.");
        }
    }

    public boolean isLagometerPermitted(IComputerAccess access) {
        if (access instanceof ITurtleAccess) {
            return LMCConfig.isLagometerAllowedOnTurtle();
        }
        if (access instanceof IPocketAccess) {
            IPocketAccess pa = (IPocketAccess)access;
            if (pa.getEntity() instanceof class_1657) {
                class_1657 plr = (class_1657)pa.getEntity();
                return !LMCConfig.lagometerNeedsChunkOwnership || plr.method_5687(2) || this.getChunkDataModule().containsOwnedLoader(plr.method_5667());
            }
            return LMCConfig.isLagometerAllowedOnTurtle();
        }
        return LMCConfig.isLagometerAllowedOnComputer();
    }
}

