/*
 * Decompiled with CFR 0.152.
 */
package com.drathonix.loadmychunks.common.registry.custom;

import com.drathonix.loadmychunks.common.system.control.ILoadState;
import com.drathonix.loadmychunks.common.system.control.LoadStateEnum;
import com.drathonix.loadmychunks.common.system.control.LoaderPower;
import com.drathonix.loadmychunks.common.util.ModResource;
import com.mojang.serialization.Lifecycle;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;

public class LoadStateRegistry
extends class_2370<ILoadState> {
    private static final List<ILoadState> statesByIndex = new ArrayList<ILoadState>();
    public static final class_5321<class_2378<ILoadState>> KEY = class_5321.method_29180((class_2960)ModResource.of("loader_state"));
    public static final LoadStateRegistry INSTANCE = new LoadStateRegistry();
    public static final ILoadState DISABLED = LoadStateEnum.DISABLED;
    public static final ILoadState TICKING = LoadStateEnum.TICKING;
    public static final ILoadState ENTITY_TICKING;
    public static final ILoadState ENTITY_TICKING_PERMANENT;
    public static final ILoadState OVERTICKED;
    public static final ILoadState PERMANENT;
    public static final ILoadState PERMANENTLY_DISABLED;

    private LoadStateRegistry() {
        super(KEY, Lifecycle.stable(), true);
    }

    private static ILoadState register(class_2960 id, ILoadState type) {
        INSTANCE.method_10272(class_5321.method_29179(KEY, (class_2960)id), type, Lifecycle.stable());
        return type;
    }

    public static ILoadState registerLoadState(class_2960 key, Function<Integer, ILoadState> stateFactory) {
        return LoadStateRegistry.registerLoadState(key, stateFactory.apply(LoadStateRegistry.getNextOpenId()));
    }

    private static ILoadState registerLoadState(class_2960 key, ILoadState state) {
        statesByIndex.add(LoadStateRegistry.register(key, state));
        return state;
    }

    private static int getNextOpenId() {
        return statesByIndex.size();
    }

    public static ILoadState fromCompound(@NotNull String key, @NotNull class_2487 tag, @NotNull ILoadState defaultState) {
        if (tag.method_10573(key, 3)) {
            int k = tag.method_10550(key);
            if (statesByIndex.size() < k || k < 0) {
                return defaultState;
            }
            return statesByIndex.get(k);
        }
        if (tag.method_10573(key, 8)) {
            Optional<class_2960> k = Optional.ofNullable(ModResource.parse(tag.method_10558(key)));
            return k.map(l -> INSTANCE.method_17966((class_2960)l).orElse(defaultState)).orElse(defaultState);
        }
        return defaultState;
    }

    static {
        OVERTICKED = LoadStateEnum.OVERTICKED;
        PERMANENT = LoadStateEnum.PERMANENT;
        PERMANENTLY_DISABLED = LoadStateEnum.PERMANENTLY_DISABLED;
        for (LoadStateEnum value : LoadStateEnum.values()) {
            LoadStateRegistry.registerLoadState(value.getResourceLocation(), value);
        }
        ENTITY_TICKING = LoadStateRegistry.registerLoadState(ModResource.of("entity_ticking"), (Integer id) -> new ILoadState((Integer)id){
            private final class_6880.class_6883<ILoadState> holder = INSTANCE.method_40269(this);
            final /* synthetic */ Integer val$id;
            {
                this.val$id = n;
            }

            @Override
            public class_6880.class_6883<ILoadState> getIntrusiveHolder() {
                return this.holder;
            }

            @Override
            public LoaderPower blockEntityTickingPower() {
                return LoaderPower.FORCED_MANAGED;
            }

            @Override
            public LoaderPower entityForcingPower() {
                return LoaderPower.FORCED_MANAGED;
            }

            @Override
            public int id() {
                return this.val$id;
            }
        });
        ENTITY_TICKING_PERMANENT = LoadStateRegistry.registerLoadState(ModResource.of("entity_ticking_permanent"), (Integer id) -> new ILoadState((Integer)id){
            private final class_6880.class_6883<ILoadState> holder = INSTANCE.method_40269(this);
            final /* synthetic */ Integer val$id;
            {
                this.val$id = n;
            }

            @Override
            public class_6880.class_6883<ILoadState> getIntrusiveHolder() {
                return this.holder;
            }

            @Override
            public LoaderPower blockEntityTickingPower() {
                return LoaderPower.FORCED;
            }

            @Override
            public LoaderPower entityForcingPower() {
                return LoaderPower.FORCED;
            }

            @Override
            public int id() {
                return this.val$id;
            }
        });
    }
}

