/*
 * Decompiled with CFR 0.152.
 */
package com.drathonix.loadmychunks.common.system;

import com.drathonix.loadmychunks.common.bridge.IInformable;
import com.drathonix.loadmychunks.common.bridge.IServerLevelMixin;
import com.drathonix.loadmychunks.common.config.LMCConfig;
import com.drathonix.loadmychunks.common.registry.custom.LoadStateRegistry;
import com.drathonix.loadmychunks.common.registry.custom.LoaderTypeRegistry;
import com.drathonix.loadmychunks.common.system.ChunkDataManager;
import com.drathonix.loadmychunks.common.system.control.CombinedTimings;
import com.drathonix.loadmychunks.common.system.control.ILoadState;
import com.drathonix.loadmychunks.common.system.control.LoadStateEnum;
import com.drathonix.loadmychunks.common.system.control.LoaderPower;
import com.drathonix.loadmychunks.common.system.control.Period;
import com.drathonix.loadmychunks.common.system.loaders.DoNotAddException;
import com.drathonix.loadmychunks.common.system.loaders.IChunkLoader;
import com.drathonix.loadmychunks.common.system.loaders.IOwnable;
import com.drathonix.loadmychunks.common.system.loaders.PlacedChunkLoader;
import com.drathonix.loadmychunks.common.util.ModResource;
import com.drathonix.loadmychunks.common.util.MultiversioningHelper;
import com.drathonix.loadmychunks.common.util.ProtectedEntityTickList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2791;
import net.minecraft.class_3218;
import net.minecraft.class_3695;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChunkDataModule {
    private final ProtectedEntityTickList entities = new ProtectedEntityTickList();
    private final CombinedTimings chunkTickTimer = new CombinedTimings();
    private Period gracePeriod;
    private Period disabledPeriod;
    public ILoadState defaultLoadState;
    private ILoadState loadState = this.defaultLoadState = LoadStateEnum.DISABLED;
    private final Set<IChunkLoader> loaders = new HashSet<IChunkLoader>();
    private final class_1923 position;
    private final Set<IInformable> recipients = new HashSet<IInformable>();
    private long nextGameTimeCheckTick = -1L;

    public ChunkDataModule(class_1923 position) {
        this.position = position;
    }

    public ChunkDataModule(long position) {
        this(new class_1923(position));
    }

    public void load(class_2487 tag, class_3218 level) {
        if (tag.method_10545("grace")) {
            this.gracePeriod = new Period(tag.method_10537("grace"));
        }
        if (tag.method_10545("disabled")) {
            this.disabledPeriod = new Period(tag.method_10537("disabled"));
        }
        if (tag.method_10545("nextCheck")) {
            this.nextGameTimeCheckTick = tag.method_10537("nextCheck");
        }
        this.loadState = this.defaultLoadState = LoadStateRegistry.fromCompound("default", tag, LoadStateRegistry.DISABLED);
        class_2499 loaders = tag.method_10554("loaders", 10);
        for (class_2520 loader : loaders) {
            if (!(loader instanceof class_2487)) continue;
            class_2487 ct = (class_2487)loader;
            LoaderTypeRegistry.INSTANCE.method_17966(ModResource.parse(ct.method_10558("type_id"))).ifPresent(obj -> {
                Object loaderInst = obj.create();
                try {
                    loaderInst.load(ct, level);
                    this.addLoader(level, (IChunkLoader)loaderInst);
                }
                catch (DoNotAddException doNotAddException) {
                    // empty catch block
                }
            });
        }
        if (this.loadState.shouldLoad()) {
            this.startGrace();
        }
    }

    public class_2487 save() {
        class_2487 tag = new class_2487();
        if (this.gracePeriod != null) {
            tag.method_10544("grace", this.gracePeriod.getEnd());
        }
        if (this.disabledPeriod != null) {
            tag.method_10544("disabled", this.disabledPeriod.getEnd());
        }
        tag.method_10544("nextCheck", this.nextGameTimeCheckTick);
        class_2499 loaders = new class_2499();
        for (IChunkLoader loader : this.loaders) {
            if (!loader.shouldPersist()) continue;
            class_2487 data = new class_2487();
            data.method_10582("type_id", loader.getTypeId().toString());
            data = loader.save(data);
            loaders.add((Object)data);
        }
        tag.method_10566("loaders", (class_2520)loaders);
        this.defaultLoadState.putCompound("default", tag);
        return tag;
    }

    public boolean addLoader(class_3218 level, @NotNull IChunkLoader loader) {
        this.loaders.add(loader);
        ILoadState previous = this.loadState;
        this.loadState = this.onCooldown() ? LoadStateEnum.OVERTICKED : loader.getActiveState().getSuperiorLoadState(this.loadState);
        this.nextGameTimeCheckTick = -1L;
        if (loader instanceof IOwnable) {
            // empty if block
        }
        return previous != this.loadState;
    }

    public boolean removeLoader(class_3218 level, @NotNull IChunkLoader loader) {
        if (loader.hasExtensions()) {
            loader.getExtensionChunkLoaders().recompute(loader.getExtensionClass(), -1, null);
        }
        this.loaders.remove(loader);
        ILoadState previous = this.loadState;
        this.update();
        this.nextGameTimeCheckTick = -1L;
        if (loader instanceof IOwnable && !this.getAllOwners().contains(((IOwnable)((Object)loader)).getOwner())) {
            ChunkDataManager.markChunkNotOwnedBy(level, this.position.method_8324(), ((IOwnable)((Object)loader)).getOwner());
        }
        return previous != this.loadState;
    }

    public void update() {
        this.loadState = this.defaultLoadState;
        if (!this.onCooldown()) {
            for (IChunkLoader loader : this.loaders) {
                this.loadState = loader.getActiveState().getSuperiorLoadState(this.loadState);
                if (this.loadState.blockEntityTickingPower() != LoaderPower.FORCED) continue;
                break;
            }
        } else {
            this.loadState = LoadStateEnum.OVERTICKED;
            this.gracePeriod = null;
        }
    }

    @NotNull
    public CombinedTimings getTickTimer() {
        return this.chunkTickTimer;
    }

    public boolean isOverticked() {
        return this.chunkTickTimer.durationExceeds(LMCConfig.msPerChunk);
    }

    @Nullable
    public Period getGracePeriod() {
        return this.gracePeriod;
    }

    @Nullable
    public Period getDisabledPeriod() {
        return this.disabledPeriod;
    }

    @NotNull
    public ILoadState getLoadState() {
        return this.loadState;
    }

    @NotNull
    public Set<IChunkLoader> getLoaders() {
        return this.loaders;
    }

    public boolean shouldUseTimings() {
        return !this.recipients.isEmpty() || this.shouldApplyTimings();
    }

    public boolean shouldApplyTimings() {
        return this.loadState.blockEntityTickingPower().isManaged() && !this.inGrace();
    }

    public boolean isPermaLoaded() {
        return this.loadState.shouldLoad() && this.loadState.permanent();
    }

    public void startGrace() {
        this.gracePeriod = Period.after(TimeUnit.SECONDS.toMillis(LMCConfig.reloadGracePeriod));
    }

    public void startShutoff() {
        this.loadState = LoadStateEnum.OVERTICKED;
        this.disabledPeriod = Period.after(TimeUnit.SECONDS.toMillis(LMCConfig.delayBeforeReload));
    }

    public boolean onCooldown() {
        return this.disabledPeriod != null && !this.disabledPeriod.hasEnded();
    }

    public boolean inGrace() {
        return this.gracePeriod != null && !this.gracePeriod.hasEnded();
    }

    @NotNull
    public class_1923 getPosition() {
        return this.position;
    }

    public boolean containsOwnedLoader(@NotNull UUID uuid) {
        for (IChunkLoader loader : this.loaders) {
            if (!(loader instanceof IOwnable) || !uuid.equals(((IOwnable)((Object)loader)).getOwner())) continue;
            return true;
        }
        return false;
    }

    public void addRecipient(IInformable informable) {
        this.recipients.add(informable);
    }

    public void removeRecipient(IInformable informable) {
        this.recipients.remove(informable);
    }

    public void inform() {
        Iterator<IInformable> iterator = this.recipients.iterator();
        float frac = this.chunkTickTimer.getLagFraction();
        while (iterator.hasNext()) {
            IInformable informable = iterator.next();
            informable.lmc$informLagFrac(frac);
            if (informable instanceof class_2586 && ((class_2586)informable).method_11015()) {
                iterator.remove();
            }
            if (!(informable instanceof class_1297) || ((class_1297)informable).method_31476().method_8324() == this.position.method_8324()) continue;
            iterator.remove();
        }
    }

    public Set<@NotNull UUID> getPlayerOwners() {
        HashSet<UUID> owners = new HashSet<UUID>();
        for (IChunkLoader loader : this.loaders) {
            if (!(loader instanceof IOwnable) || !((IOwnable)((Object)loader)).hasOwner()) continue;
            owners.add(((IOwnable)((Object)loader)).getOwner());
        }
        return owners;
    }

    public Set<@Nullable UUID> getAllOwners() {
        HashSet<UUID> owners = new HashSet<UUID>();
        for (IChunkLoader loader : this.loaders) {
            if (!(loader instanceof IOwnable)) continue;
            owners.add(((IOwnable)((Object)loader)).getOwner());
        }
        return owners;
    }

    public void clearCooldowns() {
        this.disabledPeriod = null;
        this.gracePeriod = null;
    }

    public boolean shouldPersist() {
        return this.defaultLoadState != LoadStateEnum.DISABLED || this.loadState.permanent() || !this.loaders.isEmpty();
    }

    public long getCooldownTime() {
        return this.onCooldown() ? this.getDisabledPeriod().getTimeRemaining() : 0L;
    }

    public void updateChunkLoadState(@NotNull class_3218 level, @NotNull ILoadState previous) {
        if (this.getLoadState().shouldLoad()) {
            this.startGrace();
        }
        this.getLoadState().apply(level, this.position.method_8324(), previous);
    }

    @Nullable
    public PlacedChunkLoader getChunkLoaderAt(class_2338 blockPos) {
        for (IChunkLoader loader : this.loaders) {
            if (!(loader instanceof PlacedChunkLoader) || !((PlacedChunkLoader)loader).getPosition().equals((Object)blockPos)) continue;
            return (PlacedChunkLoader)loader;
        }
        return null;
    }

    public void preTick(class_3218 level) {
        if (LMCConfig.cost.enabled && level.method_8510() >= this.nextGameTimeCheckTick) {
            boolean doStateUpdateCheck = false;
            for (IChunkLoader loader : this.loaders) {
                ILoadState pre = loader.getActiveState();
                loader.timingsCheck(level, this, level.method_8510());
                if (pre == loader.getActiveState()) continue;
                doStateUpdateCheck = true;
            }
            if (doStateUpdateCheck) {
                this.consumeLoadState(previous -> this.update(() -> this.updateChunkLoadState(level, (ILoadState)previous)));
            }
        }
    }

    public void update(Runnable onChange) {
        ILoadState pre = this.loadState;
        this.update();
        if (pre != this.loadState) {
            onChange.run();
        }
    }

    public void updateCheckTime(long time) {
        this.nextGameTimeCheckTick = time;
    }

    public void consumeLoadState(Consumer<ILoadState> consumer) {
        consumer.accept(this.loadState);
    }

    public void tickEntities(class_3218 sl, class_3695 profilerfiller) {
        boolean applyTimings = this.shouldApplyTimings();
        boolean useTimings = applyTimings || this.shouldUseTimings();
        IServerLevelMixin mixin = (IServerLevelMixin)sl;
        if (useTimings) {
            this.getTickTimer().startEntities();
        }
        this.entities.forEach(entity -> {
            if (!MultiversioningHelper.isRemoved(entity)) {
                if (mixin.lmc$shouldDiscardEntity((class_1297)entity)) {
                    entity.method_31472();
                } else {
                    profilerfiller.method_15396("checkDespawn");
                    entity.method_5982();
                    profilerfiller.method_15407();
                    class_1297 vehicle = entity.method_5854();
                    if (vehicle != null) {
                        if (!MultiversioningHelper.isRemoved(vehicle) && vehicle.method_5626(entity)) {
                            return;
                        }
                        entity.method_5848();
                    }
                    profilerfiller.method_15396("tick");
                    sl.method_18472(arg_0 -> ((class_3218)sl).method_18762(arg_0), entity);
                    profilerfiller.method_15407();
                }
            }
        });
        if (useTimings) {
            this.getTickTimer().endEntities();
        }
    }

    public void lmc$removeEntity(class_1297 entity) {
        this.entities.remove(entity);
    }

    public void lmc$addEntity(class_1297 entity) {
        this.entities.add(entity);
    }

    public void postLoad(class_3218 level, class_2791 chunkAccess) {
        Iterator<IChunkLoader> iter = this.loaders.iterator();
        boolean shouldUpdate = false;
        while (iter.hasNext()) {
            IChunkLoader loader = iter.next();
            try {
                if (!loader.postLoad(chunkAccess)) continue;
                shouldUpdate = true;
            }
            catch (DoNotAddException ex) {
                iter.remove();
                this.removeLoader(level, loader);
            }
        }
        if (shouldUpdate) {
            this.consumeLoadState(previous -> this.update(() -> this.updateChunkLoadState(level, (ILoadState)previous)));
        }
    }
}

