/*
 * Decompiled with CFR 0.152.
 */
package com.drathonix.loadmychunks.common.system.loaders;

import com.drathonix.loadmychunks.common.config.LMCConfig;
import com.drathonix.loadmychunks.common.registry.LoaderTypeKeys;
import com.drathonix.loadmychunks.common.registry.custom.LoadStateRegistry;
import com.drathonix.loadmychunks.common.system.control.ILoadState;
import com.drathonix.loadmychunks.common.system.control.LoadStateEnum;
import com.drathonix.loadmychunks.common.system.loaders.DoNotAddException;
import com.drathonix.loadmychunks.common.system.loaders.IChunkLoader;
import com.drathonix.loadmychunks.common.system.loaders.IOwnable;
import com.drathonix.loadmychunks.common.system.loaders.extension.ExtensionChunkLoaders;
import com.drathonix.loadmychunks.common.system.loaders.extension.IExtensionChunkLoader;
import com.drathonix.loadmychunks.common.system.loaders.extension.PlacedExtensionChunkLoader;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2791;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlacedChunkLoader
implements IChunkLoader,
IOwnable {
    @Nullable
    protected ExtensionChunkLoaders extensions = null;
    protected int extensionRange = 0;
    @Nullable
    protected UUID owner;
    protected class_2338 position;
    protected ILoadState defaultState;
    protected ILoadState loadState = this.defaultState = (ILoadState)LMCConfig.placedChunkLoaderDefaultLevel.get();
    protected long activityEnd = -1L;

    public PlacedChunkLoader() {
    }

    public PlacedChunkLoader(class_2338 pos) {
        this.position = pos;
    }

    public PlacedChunkLoader(class_2338 pos, long activityEnd) {
        this.position = pos;
        this.activityEnd = activityEnd;
    }

    public PlacedChunkLoader(class_2338 pos, @Nullable UUID owner) {
        this.position = pos;
        this.owner = owner;
    }

    @Override
    @NotNull
    public class_2487 save(class_2487 tag) {
        if (this.hasOwner()) {
            tag.method_25927("owner", this.owner);
        }
        if (this.hasExtensions()) {
            tag.method_10569("extensions", this.extensionRange);
        }
        tag.method_10544("duration", this.activityEnd);
        this.loadState.putCompound("state", tag);
        this.defaultState.putCompound("default", tag);
        tag.method_10544("pos", this.position.method_10063());
        return tag;
    }

    @Override
    public void load(@NotNull class_2487 tag, class_3218 level) throws DoNotAddException {
        this.position = class_2338.method_10092((long)tag.method_10537("pos"));
        if (tag.method_10545("owner")) {
            this.owner = tag.method_25926("owner");
        }
        if (tag.method_10545("duration")) {
            this.activityEnd = tag.method_10537("duration");
        }
        this.defaultState = LoadStateRegistry.fromCompound("default", tag, LoadStateRegistry.TICKING);
        this.loadState = LoadStateRegistry.fromCompound("state", tag, this.defaultState);
        if (tag.method_10545("extensions")) {
            this.extend(level, tag.method_10550("extensions"));
        }
    }

    @Override
    public boolean postLoad(class_2791 chunk) throws DoNotAddException {
        return false;
    }

    @Override
    public void setExtensionRange(int extensionRange) {
        this.extensionRange = extensionRange;
    }

    @Override
    public void setExtensionsMap(ExtensionChunkLoaders extensions) {
        this.extensions = extensions;
    }

    @Override
    public int getExtensionRange() {
        return this.extensionRange;
    }

    public PlacedExtensionChunkLoader createExtension(class_1923 position) {
        return new PlacedExtensionChunkLoader(position, this);
    }

    @Override
    public <T extends IExtensionChunkLoader<?>> Class<T> getExtensionClass() {
        return PlacedExtensionChunkLoader.class;
    }

    @Override
    public boolean supportsExtensions() {
        return true;
    }

    @Override
    public boolean supportsEntityTicking() {
        return true;
    }

    @Override
    @Nullable
    public ExtensionChunkLoaders getExtensionChunkLoaders() {
        return this.extensions;
    }

    @Override
    public ExtensionChunkLoaders.Factory<?> getExtensionFactory() {
        return this::createExtension;
    }

    @Override
    @Nullable
    public UUID getOwner() {
        return this.owner;
    }

    protected boolean outOfTime() {
        return this.shouldConsumeItems() && this.activityEnd == -1L;
    }

    @Override
    public ILoadState getActiveState() {
        if (this.hasExceededChunkLimit() || this.outOfTime()) {
            return LoadStateEnum.DISABLED;
        }
        return this.loadState;
    }

    @Override
    public ILoadState getDefaultState() {
        return this.defaultState;
    }

    @Override
    public void setActiveState(ILoadState state) {
        this.loadState = state;
    }

    @Override
    public void setOwner(@NotNull UUID owner) {
        this.owner = owner;
    }

    @NotNull
    public class_2338 getPosition() {
        return this.position;
    }

    @Override
    public class_2960 getTypeId() {
        return LoaderTypeKeys.PLACED_LOADER;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlacedChunkLoader that = (PlacedChunkLoader)o;
        return Objects.equals(this.position, that.position);
    }

    public int hashCode() {
        return Objects.hash(this.position);
    }

    @Override
    @NotNull
    public class_1923 getChunkPos() {
        return new class_1923(this.getPosition());
    }

    @Override
    public long getActivityEnd() {
        return this.activityEnd;
    }

    @Override
    public void setActivityEnd(long activityEnd) {
        this.activityEnd = activityEnd;
    }

    @Override
    @NotNull
    public class_2338 getItemSource() {
        return this.position.method_10084();
    }

    @Override
    public ILoadState setDefaultState(ILoadState defaultState) {
        ILoadState prev = this.defaultState;
        this.defaultState = defaultState;
        if (this.loadState == LoadStateRegistry.TICKING) {
            this.loadState = defaultState;
        }
        return prev;
    }
}

